/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.testsn;

import de.pfabulist.kleinod.paths.Filess;
import de.pfabulist.lindwurm.niotest.testsn.Tests07Closed;
import de.pfabulist.lindwurm.niotest.testsn.Tests08ThreadSafe;
import de.pfabulist.lindwurm.niotest.testsn.setup.AllCapabilitiesBuilder;
import de.pfabulist.lindwurm.niotest.testsn.setup.Capa;
import java.io.IOException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;

public abstract class Tests09WrongProvider
extends Tests08ThreadSafe {
    public Tests09WrongProvider(Capa capa) {
        super(capa);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testNewByteChannelOtherProvider() throws IOException {
        this.FS.provider().newByteChannel(this.otherProviderAbsA(), Collections.emptySet(), new FileAttribute[0]);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testGetBasicFileAttributeViewProvider() throws IOException {
        this.FS.provider().getFileAttributeView(this.otherProviderAbsA(), BasicFileAttributeView.class, new LinkOption[0]);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testCreateDirectoryOtherProvider() throws IOException {
        this.FS.provider().createDirectory(this.otherProviderAbsA(), new FileAttribute[0]);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testNewFileChannelOtherProvider() throws IOException {
        this.FS.provider().newFileChannel(this.otherProviderAbsA(), Collections.emptySet(), new FileAttribute[0]);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testCheckAccessOtherProvider() throws IOException {
        this.FS.provider().checkAccess(this.otherProviderAbsA(), new AccessMode[0]);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testCopyOtherProviderFrom() throws IOException {
        this.FS.provider().copy(this.otherProviderAbsA(), this.absTA(), new CopyOption[0]);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testCopyOtherProviderTo() throws IOException {
        this.FS.provider().copy(this.fileTA(), this.otherProviderAbsA(), new CopyOption[0]);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testMoveOtherProviderFrom() throws IOException {
        this.FS.provider().move(this.otherProviderAbsA(), this.absTA(), new CopyOption[0]);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testMoveOtherProviderTo() throws IOException {
        this.FS.provider().move(this.fileTAB(), this.otherProviderAbsA(), new CopyOption[0]);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testHardLinkOfDifferentProvider() throws IOException {
        this.FS.provider().createLink(this.otherProviderAbsA(), this.fileTA());
    }

    @Test(expected=ProviderMismatchException.class)
    public void testCreateSymLinkOtherProvider() throws IOException {
        this.FS.provider().createSymbolicLink(this.otherProviderAbsA(), this.otherProviderAbsA(), new FileAttribute[0]);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testDeleteOtherProvider() throws IOException {
        this.FS.provider().delete(this.otherProviderAbsA());
    }

    @Test(expected=ProviderMismatchException.class)
    public void testDeleteIfExistsOtherProvider() throws IOException {
        this.FS.provider().deleteIfExists(this.otherProviderAbsA());
    }

    @Test(expected=ProviderMismatchException.class)
    public void testGetFileStoreOtherProvider() throws IOException {
        this.FS.provider().getFileStore(this.otherProviderAbsA());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetPathOtherURI() throws IOException {
        this.FS.provider().getPath(this.otherProviderAbsA().toUri());
    }

    @Test(expected=ProviderMismatchException.class)
    public void testIsHiddenOtherProvider() throws IOException {
        this.FS.provider().isHidden(this.otherProviderAbsA());
    }

    @Test(expected=ProviderMismatchException.class)
    public void testNewAsynchronousFileChannelOtherProvider() throws IOException {
        this.FS.provider().newAsynchronousFileChannel(this.otherProviderAbsA(), Collections.emptySet(), null, new FileAttribute[0]);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testNewOutputStreamOtherProvider() throws IOException {
        this.FS.provider().newOutputStream(this.otherProviderAbsA(), new OpenOption[0]);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testNewDirectoryStreamOtherProvider() throws IOException {
        this.FS.provider().newDirectoryStream(this.otherProviderAbsA(), null);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testReadAttributesOtherProvider() throws IOException {
        this.FS.provider().readAttributes(this.otherProviderAbsA(), BasicFileAttributes.class, new LinkOption[0]);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testReadAttributesStringOtherProvider() throws IOException {
        this.FS.provider().readAttributes(this.otherProviderAbsA(), "*", new LinkOption[0]);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testReadSymLinkOtherProvider() throws IOException {
        this.FS.provider().readSymbolicLink(this.otherProviderAbsA());
    }

    @Test(expected=ProviderMismatchException.class)
    public void testResolveWithPathFromOtherProvider() throws IOException {
        this.absD().resolve(this.otherProviderAbsA());
    }

    @Test
    public void testIsSameFileOtherProvider() throws IOException {
        MatcherAssert.assertThat((Object)this.FS.provider().isSameFile(this.otherProviderAbsA(), this.absTA()), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testIsSameFileOtherProvider2() throws IOException {
        MatcherAssert.assertThat((Object)this.FS.provider().isSameFile(this.absTA(), this.otherProviderAbsA()), (Matcher)Is.is((Object)false));
    }

    protected Path otherProviderAbsA() {
        return this.getOtherProviderPlayground().resolve(this.nameA());
    }

    protected Path otherProviderFileA() {
        Path ret = this.otherProviderAbsA();
        if (!Files.exists(ret, new LinkOption[0])) {
            Filess.createDirectories((Path)ret.getParent());
            Filess.write((Path)ret, (byte[])CONTENT, (OpenOption[])new OpenOption[0]);
        }
        return ret;
    }

    public static class CapBuilder09
    extends Tests07Closed.CapBuilder07 {
        public AllCapabilitiesBuilder otherProviderPlayground(Path path) {
            this.capa.attributes.put("otherProviderPlayground", path);
            return (AllCapabilitiesBuilder)this;
        }
    }
}

