/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.testsn;

import de.pfabulist.lindwurm.niotest.testsn.Tests04Copy;
import de.pfabulist.lindwurm.niotest.testsn.setup.Capa;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public abstract class Tests05URI
extends Tests04Copy {
    public Tests05URI(Capa capa) {
        super(capa);
    }

    @Test
    public void testFileSystemOfAPathIsTheConstructingOne() {
        Assert.assertEquals((Object)this.FS, (Object)this.FS.getPath("", new String[0]).getFileSystem());
    }

    @Test
    public void testSeparatorIsNotEmpty() {
        Assert.assertThat((Object)this.FS.getSeparator().isEmpty(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testSchemeIsNotEmpty() {
        Assert.assertThat((Object)this.FS.provider().getScheme().isEmpty(), (Matcher)Is.is((Object)false));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testProviderGetFileSystemWithWrongSchemeFails() {
        this.FS.provider().getFileSystem(URI.create(this.FS.provider().getScheme() + "N:"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWrongUriAtProviderNewFails() throws IOException {
        this.FS.provider().newFileSystem(URI.create(this.FS.provider().getScheme() + "N:"), Collections.EMPTY_MAP);
    }

    @Test
    public void testToUriOfRelativePathIsTheUriOfTheAbsolute() throws Exception {
        Assert.assertThat((Object)this.pathDefault().toAbsolutePath().toUri(), (Matcher)Is.is((Object)this.pathDefault().toUri()));
    }
}

