/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.kleinod.errors.Unchecked;
import de.pfabulist.kleinod.paths.Pathss;
import de.pfabulist.kleinod.text.Strings;
import de.pfabulist.lindwurm.niotest.tests.FSCapabilities;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public abstract class Setup {
    private Path play;
    private Path foreignRoot;
    private Boolean dontDelete;
    protected static byte[] CONTENT;
    protected static byte[] CONTENT_OTHER;
    protected static byte[] CONTENT20k;
    protected static byte[] CONTENT50;
    public FileSystem FS;
    public String[] nameStr = new String[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk"};
    public String[] nameStrCase;
    private int kidCount;
    protected Map<String, String> notSupported = new HashMap<String, String>();
    public FSCapabilities capabilities;
    protected static OpenOption[] standardOpen;
    private Function<String, String> getName = s -> s;
    @Rule
    public TestName testMethodName = new TestName();
    public Path sizeLimitedPlayground;

    @BeforeClass
    public static void beforeClass3() {
        int i;
        CONTENT = Strings.getBytes((String)"hi there");
        CONTENT_OTHER = Strings.getBytes((String)"what's up, huh, huh");
        CONTENT20k = new byte[20000];
        for (i = 0; i < 20000; ++i) {
            Setup.CONTENT20k[i] = (byte)i;
        }
        CONTENT50 = new byte[50];
        for (i = 0; i < 50; ++i) {
            Setup.CONTENT50[i] = (byte)i;
        }
    }

    @Before
    public void filter() {
        Assume.assumeThat((String)this.message(), (Object)this.possible(), (Matcher)CoreMatchers.is((Object)true));
    }

    protected String message() {
        String ret = this.notSupported.get(this.testMethodName.getMethodName());
        if (ret != null) {
            return ret;
        }
        return "";
    }

    protected boolean possible() {
        String name = this.testMethodName.getMethodName();
        if (this.notSupported.containsKey(name)) {
            return false;
        }
        if (name.contains("Windows") && !this.capabilities.isWindows()) {
            return false;
        }
        if (name.contains("HardLink") && !this.capabilities.hasLinks()) {
            return false;
        }
        if (name.contains("MaxFilename") && this.capabilities.getMaxFilenameLength() < 0) {
            return false;
        }
        if (name.contains("IllegalFilename") && this.capabilities.getIllegalFilenames().isEmpty()) {
            return false;
        }
        if (name.contains("FileChannel") && !this.capabilities.supportsFileChannels()) {
            return false;
        }
        if (name.contains("ClosedFS") && !this.capabilities.isClosable()) {
            return false;
        }
        if (name.contains("SymLink") && !this.capabilities.hasSymbolicLinks()) {
            return false;
        }
        if (name.contains("ForeignSymLink") && !this.capabilities.supportsForeignSymLinks()) {
            return false;
        }
        return !name.contains("FileStore") || this.capabilities.supportsFileStores();
    }

    public Path getNonEmpty(String name, int kidCount) throws IOException {
        this.kidCount = kidCount;
        Path base = this.play.resolve(name);
        Files.createDirectories(base, new FileAttribute[0]);
        for (int i = 0; i < kidCount; ++i) {
            Files.createDirectory(base.resolve("kid-" + i), new FileAttribute[0]);
        }
        return base;
    }

    public int getKidCount() {
        return this.kidCount;
    }

    public Path getPathA() {
        return this.FS.getPath(this.nameStr[0], new String[0]);
    }

    public Path getPathB() {
        return this.FS.getPath(this.nameStr[1], new String[0]);
    }

    public Path getPathAB() {
        return this.FS.getPath(this.nameStr[0], this.nameStr[1]);
    }

    public Path getPathRAB() {
        return this.FS.getPath(this.nameStr[0], this.nameStr[1]).toAbsolutePath();
    }

    public Path getPathBC() {
        return this.FS.getPath(this.nameStr[1], this.nameStr[2]);
    }

    public Path getPathABC() {
        return this.FS.getPath(this.nameStr[0], this.nameStr[1], this.nameStr[2]);
    }

    public Path getPathRABC() {
        return this.FS.getPath(this.nameStr[0], this.nameStr[1], this.nameStr[2]).toAbsolutePath();
    }

    public Path getPathP() throws IOException {
        return this.emptyDir();
    }

    public Path getPathPA() throws IOException {
        return this.emptyDir().resolve(this.nameStr[0]);
    }

    public Path getPathPAC() throws IOException {
        return this.emptyDir().resolve(this.nameStr[0]).resolve(this.nameStr[2]);
    }

    public Path getPathPLongFileName() throws IOException {
        String name = this.nameStr[0];
        while (name.length() < this.capabilities.getMaxFilenameLength()) {
            name = name + name;
        }
        return this.getPathP().resolve(name.substring(0, this.capabilities.getMaxFilenameLength()));
    }

    public Path getPathPTooLongFileName() throws IOException {
        String name = this.nameStr[0];
        while (name.length() < this.capabilities.getMaxFilenameLength() + 1) {
            name = name + name;
        }
        return this.getPathP().resolve(name.substring(0, this.capabilities.getMaxFilenameLength() + 1));
    }

    public Path getPathPAf() throws IOException {
        Path ret = this.emptyDir().resolve(this.nameStr[0]);
        Files.write(ret, CONTENT, standardOpen);
        this.capabilities.shake().run();
        return ret;
    }

    public Path getPathPAd() throws IOException {
        Path ret = this.emptyDir().resolve(this.nameStr[0]);
        Files.createDirectory(ret, new FileAttribute[0]);
        return ret;
    }

    public Path getPathPBf() throws IOException {
        Path ret = this.emptyDir().resolve(this.nameStr[1]);
        Files.write(ret, CONTENT, standardOpen);
        return ret;
    }

    public Path getPathPBd() throws IOException {
        Path ret = this.emptyDir().resolve(this.nameStr[1]);
        Files.createDirectory(ret, new FileAttribute[0]);
        return ret;
    }

    public Path getPathPCf() throws IOException {
        Path ret = this.emptyDir().resolve(this.nameStr[2]);
        Files.write(ret, CONTENT, standardOpen);
        return ret;
    }

    public Path getPathPABf() throws IOException {
        Path ret = this.getPathPAB();
        Files.createDirectories(ret.getParent(), new FileAttribute[0]);
        Files.write(ret, CONTENT, standardOpen);
        return ret;
    }

    public Path getPathPACf() throws IOException {
        Path ret = this.getPathPAC();
        Files.createDirectories(ret.getParent(), new FileAttribute[0]);
        Files.write(ret, CONTENT, standardOpen);
        return ret;
    }

    public Path getPathPADf() throws IOException {
        Path ret = this.getPathPA().resolve(this.nameStr[3]);
        Files.createDirectories(ret.getParent(), new FileAttribute[0]);
        Files.write(ret, CONTENT, standardOpen);
        return ret;
    }

    public Path getPathPBCf() throws IOException {
        Path ret = this.getPathPB().resolve(this.nameStr[2]);
        Files.createDirectories(ret.getParent(), new FileAttribute[0]);
        Files.write(ret, CONTENT, standardOpen);
        return ret;
    }

    public Path getPathPABr() throws IOException {
        return this.getDefaultPath().toAbsolutePath().relativize(this.getPathPAB());
    }

    public Path getPathPAu() throws IOException {
        return this.getPathPA().getParent().resolve(this.nameStr[2]).resolve("..").resolve(this.nameStr[0]);
    }

    public Path getPathPABu() throws IOException {
        return this.getPathPAB().getParent().resolve("..").resolve(this.nameStr[0]).resolve(this.nameStr[1]);
    }

    public Path getPathPB() throws IOException {
        return this.emptyDir().resolve(this.nameStr[1]);
    }

    public Path getPathPBB() throws IOException {
        return this.emptyDir().resolve(this.nameStr[1]).resolve(this.nameStr[1]);
    }

    public Path getPathPAB() throws IOException {
        return this.emptyDir().resolve(this.nameStr[0]).resolve(this.nameStr[1]);
    }

    public Path getPathPC() throws IOException {
        return this.emptyDir().resolve(this.nameStr[3]);
    }

    public Path getPathPCD() throws IOException {
        return this.emptyDir().resolve(this.nameStr[3]).resolve(this.nameStr[4]);
    }

    public Path getRoot() {
        return this.FS.getPath("", new String[0]).toAbsolutePath().getRoot();
    }

    public Path getDefaultPath() {
        return this.FS.getPath("", new String[0]);
    }

    public Path getName(int i) {
        return this.FS.getPath(this.nameStr[i], new String[0]);
    }

    public String getSeparator() {
        return this.FS.getSeparator();
    }

    public Path nonEmptyDir() throws IOException {
        return this.getNonEmpty(this.testMethodName.getMethodName(), 4);
    }

    public Path emptyDir() throws IOException {
        return this.getNonEmpty(this.testMethodName.getMethodName(), 0);
    }

    @Test
    public void testAAA0() {
        Assert.assertThat((String)"set FS to the FileSystem to test", (Object)this.FS, (Matcher)CoreMatchers.notNullValue());
    }

    public void setPlay(Path play) {
        this.play = play;
        this.FS = play.getFileSystem();
    }

    public Path getPlay() {
        return this.play;
    }

    public Path getOther() throws IOException {
        if (this.FS.equals(FileSystems.getDefault())) {
            return Pathss.getOrCreate((URI)URI.create("null:/"), (Map)Collections.EMPTY_MAP).getPath("/", new String[0]);
        }
        return FileSystems.getDefault().getPath("foo", new String[0]);
    }

    public Path getForeignPathP() {
        if (this.FS.equals(FileSystems.getDefault())) {
            throw new UnsupportedOperationException();
        }
        if (this.foreignRoot == null) {
            this.foreignRoot = Pathss.getTmpDir((String)"niotestforeign");
        }
        Path ret = this.foreignRoot.resolve(this.testMethodName.getMethodName());
        try {
            Files.createDirectories(ret, new FileAttribute[0]);
            return ret;
        }
        catch (IOException e) {
            throw Unchecked.runtime((Exception)e);
        }
    }

    public String getName(String str) {
        return this.getName.apply(str);
    }

    static {
        standardOpen = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE};
    }
}

