/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.lindwurm.niotest.matcher.FileTimeMatcher;
import de.pfabulist.lindwurm.niotest.tests.PathTest5URIIT;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public abstract class PathTest6AttributesIT
extends PathTest5URIIT {
    @Test
    public void testGetLastModifiedTime() throws IOException {
        Files.readAttributes(this.getDefaultPath(), BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime();
    }

    @Test
    public void testGetCreationTimeIsRecent() throws IOException {
        FileTime created = Files.readAttributes(this.getPathPA().getParent(), BasicFileAttributes.class, new LinkOption[0]).creationTime();
        Assert.assertThat((Object)created, FileTimeMatcher.isCloseTo(FileTime.fromMillis(System.currentTimeMillis())));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testReadAttributesAskingForUnknownAttributesThrows() throws Exception {
        Files.readAttributes(this.getDefaultPath(), SomeFileAttributes.class, new LinkOption[0]);
    }

    @Test
    public void testSizeOfDirDoesNotThrow() throws IOException {
        Files.size(this.getDefaultPath());
    }

    @Test
    public void testRootIsNotASymbolicLink() {
        Assert.assertThat((String)"root is a symbolic link", (Object)Files.isSymbolicLink(this.getRoot()), (Matcher)CoreMatchers.not((Object)true));
    }

    @Test
    public void testBasicIsASupportedFileAttributeView() {
        Assert.assertThat(this.FS.supportedFileAttributeViews(), (Matcher)CoreMatchers.hasItem((Object)"basic"));
    }

    @Test
    public void testGetLastModifiedAllMethodsDeliverSame() throws IOException {
        Path path = this.getPathPAf();
        FileTime last0 = Files.getLastModifiedTime(path, new LinkOption[0]);
        FileTime last1 = this.FS.provider().readAttributes(path, BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime();
        FileTime last2 = (FileTime)this.FS.provider().readAttributes(path, "basic:lastModifiedTime", new LinkOption[0]).get("lastModifiedTime");
        FileTime last3 = this.FS.provider().getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]).readAttributes().lastModifiedTime();
        Assert.assertThat((Object)last0, (Matcher)CoreMatchers.is((Object)last1));
        Assert.assertThat((Object)last1, (Matcher)CoreMatchers.is((Object)last2));
        Assert.assertThat((Object)last2, (Matcher)CoreMatchers.is((Object)last3));
        Assert.assertThat((Object)last3, (Matcher)CoreMatchers.is((Object)last0));
    }

    @Test
    public void testGetLastModifiedViaStringOfRelativePath() throws IOException {
        Path path = this.getPathPAf();
        Assert.assertThat((Object)((FileTime)this.FS.provider().readAttributes(this.getDefaultPath().toAbsolutePath().relativize(path), "basic:lastModifiedTime", new LinkOption[0]).get("lastModifiedTime")), (Matcher)CoreMatchers.is((Object)((FileTime)this.FS.provider().readAttributes(path, "basic:lastModifiedTime", new LinkOption[0]).get("lastModifiedTime"))));
    }

    @Test
    public void testGetAllBasicAttributes() throws IOException {
        Path path = this.getPathPAf();
        Map<String, Object> attis = this.FS.provider().readAttributes(path, "basic:*", new LinkOption[0]);
        Assert.assertThat(attis.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"size", "creationTime", "lastAccessTime", "lastModifiedTime", "fileKey", "isDirectory", "isRegularFile", "isSymbolicLink", "isOther"}));
    }

    @Test
    public void testUnsupportedAttributeViewReturnsNull() {
        Assert.assertThat((Object)this.FS.provider().getFileAttributeView(this.getDefaultPath(), UnsiView.class, new LinkOption[0]), (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testUnsupportedAttributesThrows() throws IOException {
        this.FS.provider().readAttributes(this.getDefaultPath(), UnsiAttris.class, new LinkOption[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testReadUnsupportedAttributesThrows() throws IOException {
        this.FS.provider().readAttributes(this.getDefaultPath(), "thisissuchasillyattributesname:duda", new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReadAttributesUnknownAttributeThrows() throws IOException {
        this.FS.provider().readAttributes(this.getDefaultPath(), "basic:duda", new LinkOption[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetUnsupportedAttributeThrows() throws IOException {
        this.FS.provider().setAttribute(this.getPathPAf(), "whoaa:freeze", true, new LinkOption[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetUnsupportedAttributeThrows() throws IOException {
        Files.getAttribute(this.getPathPAf(), "whoaa:freeze", new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetUnsupportedAttributeThrows2() throws IOException {
        Files.getAttribute(this.getPathPAf(), "basic:freeze", new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReadAttributesOneUnknownAttributeThrows() throws IOException {
        this.FS.provider().readAttributes(this.getDefaultPath(), "basic:lastModifiedTime,duda", new LinkOption[0]);
    }

    @Test
    public void testSetLastModifiedTimeViaString() throws IOException {
        FileTime past = FileTime.fromMillis(System.currentTimeMillis() - 100000L);
        Path file = this.getPathPAf();
        this.FS.provider().setAttribute(file, "basic:lastModifiedTime", past, new LinkOption[0]);
        Assert.assertThat((Object)Files.getLastModifiedTime(file, new LinkOption[0]), FileTimeMatcher.isCloseTo(past));
    }

    @Test
    public void testSetLastModifiedTimeViaFiles() throws IOException {
        FileTime past = FileTime.fromMillis(System.currentTimeMillis() - 100000L);
        Path file = this.getPathPAf();
        Files.setLastModifiedTime(file, past);
        Assert.assertThat((Object)Files.getLastModifiedTime(file, new LinkOption[0]), FileTimeMatcher.isCloseTo(past));
    }

    @Test
    public void testSetLastModifiedTimeViaView() throws IOException {
        FileTime past = FileTime.fromMillis(System.currentTimeMillis() - 100000L);
        Path file = this.getPathPAf();
        this.FS.provider().getFileAttributeView(file, BasicFileAttributeView.class, new LinkOption[0]).setTimes(past, null, null);
        Assert.assertThat((Object)Files.getLastModifiedTime(file, new LinkOption[0]), FileTimeMatcher.isCloseTo(past));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetSizeThrows() throws IOException {
        this.FS.provider().setAttribute(this.getPathPAf(), "basic:size", 7, new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetIsLinkThrows() throws IOException {
        this.FS.provider().setAttribute(this.getPathPAf(), "basic:isSymbolicLink", true, new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetIsDirectoryThrows() throws IOException {
        this.FS.provider().setAttribute(this.getPathPAf(), "basic:isDirectory", true, new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetIsRegularFileThrows() throws IOException {
        this.FS.provider().setAttribute(this.getPathPAf(), "basic:isRegularFile", true, new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetFileKeyThrows() throws IOException {
        this.FS.provider().setAttribute(this.getPathPAf(), "basic:fileKey", true, new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetIsOtherThrows() throws IOException {
        this.FS.provider().setAttribute(this.getPathPAf(), "basic:isOther", true, new LinkOption[0]);
    }

    @Test
    public void testSetCreationTimeViaString() throws IOException {
        Assume.assumeThat((Object)this.capabilities.supportsCreationTime(), (Matcher)CoreMatchers.is((Object)true));
        FileTime past = FileTime.fromMillis(System.currentTimeMillis() - 100000L);
        Path file = this.getPathPAf();
        this.FS.provider().setAttribute(file, "basic:creationTime", past, new LinkOption[0]);
        Assert.assertThat((Object)Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).creationTime(), FileTimeMatcher.isCloseTo(past));
    }

    @Test
    public void testSetCreationTimeDoesNotChangeLastAccessTime() throws IOException, InterruptedException {
        Assume.assumeThat((Object)this.capabilities.supportsLastAccessTime(), (Matcher)Is.is((Object)true));
        Path file = this.getPathPAf();
        FileTime before = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
        Thread.sleep(2000L);
        this.FS.provider().setAttribute(file, "basic:creationTime", FileTime.fromMillis(System.currentTimeMillis() - 100000L), new LinkOption[0]);
        Assert.assertThat((Object)Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime(), (Matcher)CoreMatchers.is((Object)before));
    }

    @Test
    public void testSetCreationTimeViaView() throws IOException {
        Assume.assumeThat((Object)this.capabilities.supportsCreationTime(), (Matcher)CoreMatchers.is((Object)true));
        FileTime past = FileTime.fromMillis(System.currentTimeMillis() - 100000L);
        Path file = this.getPathPAf();
        this.FS.provider().getFileAttributeView(file, BasicFileAttributeView.class, new LinkOption[0]).setTimes(null, null, past);
        Assert.assertThat((Object)Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).creationTime(), FileTimeMatcher.isCloseTo(past));
    }

    @Test
    public void testSetLastAccessTimeViaString() throws IOException {
        Assume.assumeThat((Object)this.capabilities.supportsLastAccessTime(), (Matcher)CoreMatchers.is((Object)true));
        FileTime past = FileTime.fromMillis(System.currentTimeMillis() - 100000L);
        Path file = this.getPathPAf();
        this.FS.provider().setAttribute(file, "basic:lastAccessTime", past, new LinkOption[0]);
        Assert.assertThat((Object)Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime(), FileTimeMatcher.isCloseTo(past));
    }

    @Test
    public void testSetLastAccessTimeViaView() throws IOException {
        Assume.assumeThat((Object)this.capabilities.supportsLastAccessTime(), (Matcher)CoreMatchers.is((Object)true));
        FileTime past = FileTime.fromMillis(System.currentTimeMillis() - 100000L);
        Path file = this.getPathPAf();
        this.FS.provider().getFileAttributeView(file, BasicFileAttributeView.class, new LinkOption[0]).setTimes(null, past, null);
        Assert.assertThat((Object)Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime(), FileTimeMatcher.isCloseTo(past));
    }

    @Test(expected=NoSuchFileException.class)
    public void testGetAttributeFromNonExistingFile() throws IOException {
        Files.getLastModifiedTime(this.getPathPA(), new LinkOption[0]);
    }

    @Test(expected=NoSuchFileException.class)
    public void testReadAttributesByStringFromNonExistingFile() throws IOException {
        Files.readAttributes(this.getPathPA(), "basic:size", new LinkOption[0]);
    }

    @Test
    public void testReadAttributesViewFromNonExistingFile() throws IOException {
        Assert.assertThat((Object)this.FS.provider().getFileAttributeView(this.getPathPA(), BasicFileAttributeView.class, new LinkOption[0]), (Matcher)CoreMatchers.notNullValue());
    }

    @Test(expected=NoSuchFileException.class)
    public void testReadAttributesViewAndReadFromNonExistingFile() throws IOException {
        BasicFileAttributeView view = this.FS.provider().getFileAttributeView(this.getPathPA(), BasicFileAttributeView.class, new LinkOption[0]);
        view.readAttributes();
    }

    @Test
    public void testReadAttributesViewFutureExistingFile() throws IOException {
        BasicFileAttributeView view = this.FS.provider().getFileAttributeView(this.getPathPA(), BasicFileAttributeView.class, new LinkOption[0]);
        this.getPathPAf();
        view.readAttributes();
    }

    @Test(expected=NoSuchFileException.class)
    public void testReadAttributesFromNonExistingFile() throws IOException {
        Files.readAttributes(this.getPathPA(), BasicFileAttributes.class, new LinkOption[0]);
    }

    @Test
    public void testFileKeyIsId() throws IOException {
        Assume.assumeThat((Object)Files.readAttributes(this.getPathPABf(), BasicFileAttributes.class, new LinkOption[0]).fileKey(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat(Files.readAttributes(this.getPathPABf(), "basic:fileKey", new LinkOption[0]), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not(Files.readAttributes(this.getPathPACf(), "basic:fileKey", new LinkOption[0]))));
    }

    public static interface UnsiAttris
    extends BasicFileAttributes {
    }

    public static interface UnsiView
    extends BasicFileAttributeView {
    }

    public static class SomeFileAttributes
    implements BasicFileAttributes {
        @Override
        public FileTime lastModifiedTime() {
            return null;
        }

        @Override
        public FileTime lastAccessTime() {
            return null;
        }

        @Override
        public FileTime creationTime() {
            return null;
        }

        @Override
        public boolean isRegularFile() {
            return false;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public boolean isSymbolicLink() {
            return false;
        }

        @Override
        public boolean isOther() {
            return false;
        }

        @Override
        public long size() {
            return 0L;
        }

        @Override
        public Object fileKey() {
            return null;
        }
    }
}

