/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.lindwurm.niotest.matcher.IteratorMatcher;
import de.pfabulist.lindwurm.niotest.matcher.PathExists;
import de.pfabulist.lindwurm.niotest.matcher.PathIsDirectory;
import de.pfabulist.lindwurm.niotest.tests.PathTest3FileIT;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableWithSize;
import org.hamcrest.number.OrderingComparison;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public abstract class PathTest4CopyIT
extends PathTest3FileIT {
    private Path src;
    private Path tgt;

    private void copyMoveSetup() throws IOException {
        this.src = this.getPathPA();
        this.tgt = this.getPathPB();
        Files.write(this.src, CONTENT, standardOpen);
    }

    private void checkContentOTarget() throws IOException {
        Assert.assertArrayEquals((byte[])CONTENT, (byte[])Files.readAllBytes(this.tgt));
    }

    @Test
    public void testCopyDuplicatesTheContent() throws IOException {
        this.copyMoveSetup();
        Files.copy(this.src, this.tgt, new CopyOption[0]);
        this.checkContentOTarget();
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void testCopyAlreadyThereWithoutOptionThrows() throws IOException {
        this.copyMoveSetup();
        Files.write(this.tgt, CONTENT, standardOpen);
        Files.copy(this.src, this.tgt, new CopyOption[0]);
        Assert.fail((String)"should not get here");
    }

    @Test
    public void testCopyAlreadyThereOverwrite() throws IOException {
        this.copyMoveSetup();
        Files.write(this.tgt, CONTENT, standardOpen);
        Files.copy(this.src, this.tgt, StandardCopyOption.REPLACE_EXISTING);
        this.checkContentOTarget();
    }

    @Test
    public void testCopyViaProvider() throws IOException {
        this.copyMoveSetup();
        this.src.getFileSystem().provider().copy(this.src, this.tgt, new CopyOption[0]);
        this.checkContentOTarget();
    }

    @Test
    public void testCopyResultHasCreationTime() throws Exception {
        this.copyMoveSetup();
        FileTime before = Files.getLastModifiedTime(this.src, new LinkOption[0]);
        Thread.sleep(2000L);
        Files.copy(this.src, this.tgt, new CopyOption[0]);
        FileTime created = Files.readAttributes(this.tgt, BasicFileAttributes.class, new LinkOption[0]).creationTime();
        Assert.assertThat((Object)created, (Matcher)OrderingComparison.greaterThan((Comparable)before));
    }

    @Test
    public void testCopyAttributesCheckModifiedTime() throws Exception {
        this.copyMoveSetup();
        BasicFileAttributes srcAttis = Files.readAttributes(this.src, BasicFileAttributes.class, new LinkOption[0]);
        Thread.sleep(2000L);
        Files.copy(this.src, this.tgt, StandardCopyOption.COPY_ATTRIBUTES);
        BasicFileAttributes tgtAttis = Files.readAttributes(this.tgt, BasicFileAttributes.class, new LinkOption[0]);
        Assert.assertThat((Object)tgtAttis.lastModifiedTime(), (Matcher)CoreMatchers.is((Object)srcAttis.lastModifiedTime()));
    }

    @Test
    public void testCopyDoesNotModifyOriginal() throws Exception {
        this.copyMoveSetup();
        FileTime beforeCopy = Files.getLastModifiedTime(this.src, new LinkOption[0]);
        Files.copy(this.src, this.tgt, new CopyOption[0]);
        Assert.assertThat((Object)this.src, PathExists.exists());
        Assert.assertEquals((Object)beforeCopy, (Object)Files.getLastModifiedTime(this.src, new LinkOption[0]));
    }

    @Test
    public void testModifyOriginalAfterCopyDoesNotChangeTarget() throws Exception {
        this.copyMoveSetup();
        Files.copy(this.src, this.tgt, new CopyOption[0]);
        Files.write(this.src, CONTENT_OTHER, new OpenOption[0]);
        Assert.assertThat((Object)Files.readAllBytes(this.tgt), (Matcher)CoreMatchers.is((Object)CONTENT));
    }

    @Test
    public void testMoveCreatesNewFileDeletesOriginal() throws IOException {
        this.copyMoveSetup();
        Files.move(this.src, this.tgt, new CopyOption[0]);
        this.checkContentOTarget();
        Assert.assertThat((Object)this.src, (Matcher)CoreMatchers.not(PathExists.exists()));
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void testMoveAlreadyThereThrows() throws IOException {
        this.copyMoveSetup();
        Files.write(this.tgt, CONTENT_OTHER, standardOpen);
        Files.move(this.src, this.tgt, new CopyOption[0]);
    }

    @Test
    public void testFailedMoveLeavesOriginal() throws Exception {
        this.copyMoveSetup();
        Files.write(this.tgt, CONTENT, standardOpen);
        try {
            Files.move(this.src, this.tgt, new CopyOption[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
        Assert.assertThat((Object)this.src, PathExists.exists());
    }

    @Test
    public void testMoveAlreadyThereOverwrite() throws Exception {
        this.copyMoveSetup();
        Files.write(this.tgt, CONTENT_OTHER, standardOpen);
        Files.move(this.src, this.tgt, StandardCopyOption.REPLACE_EXISTING);
        this.checkContentOTarget();
        Assert.assertThat((Object)this.src, (Matcher)CoreMatchers.not(PathExists.exists()));
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void testMoveAlreadyThereDirectory() throws Exception {
        Path src = this.getPathPABf();
        Path tgt = this.getPathPBd();
        Files.move(src, tgt, new CopyOption[0]);
    }

    @Test
    public void testMoveAlreadyThereDirectoryOverwrite() throws Exception {
        Path src = this.getPathPABf();
        Path tgt = this.getPathPBd();
        Files.move(src, tgt, StandardCopyOption.REPLACE_EXISTING);
        Assert.assertThat((Object)Files.readAllBytes(tgt), (Matcher)CoreMatchers.is((Object)CONTENT));
        Assert.assertThat((Object)src, (Matcher)CoreMatchers.not(PathExists.exists()));
    }

    @Test(expected=DirectoryNotEmptyException.class)
    public void testMoveAlreadyThereNonEmptyDirectoryOverwrite() throws Exception {
        Path src = this.getPathPABf();
        Path tgt = this.getPathPBCf().getParent();
        Files.move(src, tgt, StandardCopyOption.REPLACE_EXISTING);
    }

    @Test
    public void testMoveViaProvider() throws IOException {
        this.copyMoveSetup();
        this.src.getFileSystem().provider().move(this.src, this.tgt, new CopyOption[0]);
        this.checkContentOTarget();
        Assert.assertThat((Object)this.src, (Matcher)CoreMatchers.not(PathExists.exists()));
    }

    @Test
    public void testMoveDir() throws IOException {
        Path src = this.getPathPAd();
        Files.move(src, this.getPathPB(), new CopyOption[0]);
        Assert.assertThat((Object)this.getPathPB(), PathIsDirectory.isDirectory());
    }

    @Test
    public void testMoveNonEmptyDir() throws IOException {
        this.getPathPADf();
        this.getPathPACf();
        Path deep = this.getPathPA().resolve(this.nameStr[0]).resolve(this.nameStr[0]);
        Files.createDirectories(deep.getParent(), new FileAttribute[0]);
        Files.write(deep, CONTENT, new OpenOption[0]);
        Path src = this.getPathPA();
        Files.move(src, this.getPathPB(), new CopyOption[0]);
        Assert.assertThat((Object)this.getPathPB().resolve(this.nameStr[0]).resolve(this.nameStr[0]), PathExists.exists());
    }

    @Test(expected=IOException.class)
    public void testMoveIntoItself() throws IOException {
        Path src = this.getPathPAd();
        Files.move(src, this.getPathPAB(), new CopyOption[0]);
    }

    @Test(expected=FileSystemException.class)
    public void testMoveRoot() throws IOException {
        Files.move(this.getRoot(), this.getPathPB(), new CopyOption[0]);
    }

    @Test
    public void testMoveKeepsLastModifiedTime() throws IOException, InterruptedException {
        Path src = this.getPathPABf();
        Path tgt = this.getPathPB();
        FileTime modi = Files.getLastModifiedTime(src, new LinkOption[0]);
        Thread.sleep(2000L);
        Files.move(src, tgt, new CopyOption[0]);
        Assert.assertThat((Object)Files.getLastModifiedTime(tgt, new LinkOption[0]), (Matcher)CoreMatchers.is((Object)modi));
    }

    @Test
    public void testMoveChangesModifiedTimeOfParent() throws IOException, InterruptedException {
        Path src = this.getPathPABf();
        Path tgt = this.getPathPB();
        FileTime modi = Files.getLastModifiedTime(src.getParent(), new LinkOption[0]);
        Thread.sleep(2000L);
        Files.move(src, tgt, new CopyOption[0]);
        Assert.assertThat((Object)Files.getLastModifiedTime(src.getParent(), new LinkOption[0]), (Matcher)OrderingComparison.greaterThan((Comparable)modi));
    }

    @Test
    public void testMoveChangesModifiedTimeOfTargetsParent() throws IOException, InterruptedException {
        Path src = this.getPathPABf();
        Path tgt = this.getPathPB();
        FileTime modi = Files.getLastModifiedTime(tgt.getParent(), new LinkOption[0]);
        Thread.sleep(2000L);
        Files.move(src, tgt, new CopyOption[0]);
        Assert.assertThat((Object)Files.getLastModifiedTime(tgt.getParent(), new LinkOption[0]), (Matcher)OrderingComparison.greaterThan((Comparable)modi));
    }

    @Test
    public void testCopyDirCreatesADirWithTheTargetName() throws Exception {
        Path kid = this.getPathPAB();
        Files.createDirectories(kid, new FileAttribute[0]);
        Path tgt = this.getPathPC();
        Files.copy(kid.getParent(), tgt, new CopyOption[0]);
        Assert.assertThat((Object)tgt, PathExists.exists());
    }

    @Test
    public void testCopyNonEmptyDirDoesNotCopyKids() throws Exception {
        Path src = this.nonEmptyDir();
        Path tgt = this.getPathPA();
        Files.copy(src, tgt, new CopyOption[0]);
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(tgt);){
            Assert.assertThat(kids, (Matcher)IsIterableWithSize.iterableWithSize((int)0));
        }
    }

    @Test
    public void testCopyDirReplaceExistingOverwritesFile() throws Exception {
        Path tgt = this.getPathPA();
        Files.write(tgt, CONTENT, standardOpen);
        Path src = this.getPathPB();
        Files.createDirectories(src, new FileAttribute[0]);
        Files.copy(src, tgt, StandardCopyOption.REPLACE_EXISTING);
        Assert.assertThat((Object)tgt, PathIsDirectory.isDirectory());
    }

    @Test(expected=DirectoryNotEmptyException.class)
    public void testCopyFileReplaceExistingDoesNotOverwriteExistingNonEmptyDir() throws Exception {
        this.copyMoveSetup();
        Files.createDirectories(this.tgt, new FileAttribute[0]);
        Files.write(this.tgt.resolve(this.getPathA()), CONTENT, standardOpen);
        Files.copy(this.src, this.tgt, StandardCopyOption.REPLACE_EXISTING);
    }

    @Test
    public void testCopyFileReplaceExistingOverwritesExistingDir() throws Exception {
        this.copyMoveSetup();
        Files.createDirectories(this.tgt, new FileAttribute[0]);
        Files.copy(this.src, this.tgt, StandardCopyOption.REPLACE_EXISTING);
    }

    @Test
    public void testDeleteDeletes() throws Exception {
        Path file = this.getPathPAf();
        Files.delete(file);
        Assert.assertThat((Object)file, (Matcher)CoreMatchers.not(PathExists.exists()));
    }

    @Test
    public void testDeleteDirRemovesItFromParentsKids() throws IOException, InterruptedException {
        Path file = this.getPathPAf();
        Files.delete(file);
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(file.getParent());){
            Assert.assertThat((Object)file, (Matcher)CoreMatchers.not(IteratorMatcher.isIn(kids)));
        }
    }

    @Test
    public void testDeleteFileRemovesItFromParentsKids() throws IOException, InterruptedException {
        Path file = this.getPathPA();
        Files.write(file, CONTENT, standardOpen);
        Files.delete(file);
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(file.getParent());){
            Assert.assertThat((Object)file, (Matcher)CoreMatchers.not(IteratorMatcher.isIn(kids)));
        }
    }

    @Test(expected=DirectoryNotEmptyException.class)
    public void testDeleteNonEmptyDirectoryThrows() throws IOException {
        Files.delete(this.getPathPABf().getParent());
    }

    @Test
    public void testDeleteEmptyDir() throws IOException {
        Path dir = this.getPathPA();
        Files.createDirectory(dir, new FileAttribute[0]);
        Files.delete(dir);
        Assert.assertThat((Object)dir, (Matcher)CoreMatchers.not(PathExists.exists()));
    }

    @Test
    public void testDeleteEmptiedDir() throws IOException {
        Path file = this.getPathPABf();
        Files.delete(file);
        Files.delete(file.getParent());
        Assert.assertThat((Object)file.getParent(), (Matcher)CoreMatchers.not(PathExists.exists()));
    }

    @Test
    public void testDeleteFileChangesParentsModificationTime() throws IOException, InterruptedException {
        Path dir = this.getPathPA();
        Path kid = this.getPathPABf();
        FileTime created = Files.getLastModifiedTime(dir, new LinkOption[0]);
        Thread.sleep(2000L);
        Files.delete(kid);
        FileTime modified = Files.getLastModifiedTime(dir, new LinkOption[0]);
        Assert.assertThat((String)"delete does not modify time", (Object)modified, (Matcher)OrderingComparison.greaterThan((Comparable)created));
    }

    @Test
    public void testDeleteFileDoesNotChangeParentCreationTime() throws IOException, InterruptedException {
        Assume.assumeThat((Object)this.capabilities.supportsCreationTime(), (Matcher)CoreMatchers.is((Object)true));
        Path parent = this.getPathPA();
        Path kid = this.getPathPABf();
        FileTime created = Files.readAttributes(parent, BasicFileAttributes.class, new LinkOption[0]).creationTime();
        Thread.sleep(2000L);
        Files.delete(kid);
        FileTime modified = Files.readAttributes(parent, BasicFileAttributes.class, new LinkOption[0]).creationTime();
        Assert.assertThat((String)"delete does modify creation time", (Object)modified, (Matcher)CoreMatchers.is((Object)created));
    }

    @Test
    public void testDeleteDirChangesParentsModificationTime() throws IOException, InterruptedException {
        Path dir = this.getPathPA();
        Path kid = this.getPathPAB();
        Files.createDirectories(kid, new FileAttribute[0]);
        FileTime created = Files.getLastModifiedTime(dir, new LinkOption[0]);
        Thread.sleep(2000L);
        Files.delete(kid);
        FileTime modified = Files.getLastModifiedTime(dir, new LinkOption[0]);
        Assert.assertThat((String)"delete does not modify time", (Object)modified, (Matcher)OrderingComparison.greaterThan((Comparable)created));
    }

    @Test
    public void testDeleteDirNotChangeParentsCreationTime() throws IOException, InterruptedException {
        Assume.assumeThat((Object)this.capabilities.supportsCreationTime(), (Matcher)CoreMatchers.is((Object)true));
        Path parent = this.getPathPA();
        Path kid = this.getPathPAB();
        Files.createDirectories(kid, new FileAttribute[0]);
        FileTime created = Files.readAttributes(parent, BasicFileAttributes.class, new LinkOption[0]).creationTime();
        Thread.sleep(2000L);
        Files.delete(kid);
        FileTime modified = Files.readAttributes(parent, BasicFileAttributes.class, new LinkOption[0]).creationTime();
        Assert.assertThat((String)"delete does modify creation time", (Object)modified, (Matcher)CoreMatchers.is((Object)created));
    }

    @Test(expected=NoSuchFileException.class)
    public void testDeleteNonExistingFileThrows() throws IOException {
        Files.delete(this.getPathPA());
    }

    @Test
    public void testDeleteRecreate() throws IOException {
        Path path = this.getPathPABf();
        Files.delete(path);
        Files.write(path, CONTENT, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
    }

    @Test
    public void testDeleteIfExistsRecreate() throws IOException {
        Path path = this.getPathPABf();
        Files.deleteIfExists(path);
        Files.write(path, CONTENT, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    @Test
    public void testRenameSourceIsNoLongerKid() throws IOException {
        Path source = this.getPathPAf();
        Path to = this.getPathPB();
        Files.move(source, to, new CopyOption[0]);
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(to.getParent());){
            Assert.assertThat((Object)source, (Matcher)CoreMatchers.not(IteratorMatcher.isIn(kids)));
        }
    }

    @Test
    public void testRenameTargetIsKid() throws IOException {
        Path source = this.getPathPAf();
        Path to = this.getPathPB();
        Files.move(source, to, new CopyOption[0]);
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(to.getParent());){
            Assert.assertThat((Object)to, IteratorMatcher.isIn(kids));
        }
    }

    @Test
    public void testMoveToSibling() throws IOException {
        Path source = this.getPathPABf();
        Path to = this.getPathPAC().resolve(this.nameStr[1]);
        Files.createDirectories(to.getParent(), new FileAttribute[0]);
        Files.move(source, to, new CopyOption[0]);
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(to.getParent());){
            Assert.assertThat((Object)to, IteratorMatcher.isIn(kids));
        }
        Assert.assertThat((Object)to, PathExists.exists());
    }

    @Test(expected=NoSuchFileException.class)
    public void testMoveToFileWithNonExistingParentThrows() throws IOException {
        Path source = this.getPathPABf();
        Path to = this.getPathPAC().resolve(this.nameStr[1]);
        Files.move(source, to, new CopyOption[0]);
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(to.getParent());){
            Assert.assertThat((Object)to, IteratorMatcher.isIn(kids));
        }
        Assert.assertThat((Object)to, PathExists.exists());
    }
}

