/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.lindwurm.niotest.matcher.PathExists;
import de.pfabulist.lindwurm.niotest.tests.PathTest18FileChannelsIT;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assume;
import org.junit.Test;

public abstract class PathTest19HardLinksIT
extends PathTest18FileChannelsIT {
    @Test
    public void testHardLinkCreate() throws IOException {
        Path orig = this.getPathPABf();
        Path link = this.getPathPAC();
        Files.createLink(link, orig);
        MatcherAssert.assertThat((Object)link, PathExists.exists());
    }

    @Test
    public void testHardLinkChangeOneChangesTheOther() throws IOException {
        Path orig = this.getPathPABf();
        Path link = this.getPathPAC();
        Files.createLink(link, orig);
        Files.write(link, CONTENT_OTHER, new OpenOption[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(orig), (Matcher)Is.is((Object)CONTENT_OTHER));
    }

    @Test
    public void testHardLinkDeleteOrigDoesNotAffectTheOther() throws IOException {
        Path orig = this.getPathPABf();
        Path link = this.getPathPAC();
        Files.createLink(link, orig);
        Files.delete(orig);
        MatcherAssert.assertThat((Object)Files.readAllBytes(link), (Matcher)Is.is((Object)CONTENT));
    }

    @Test
    public void testHardLinkDeleteLinkDoesNotAffectTheOther() throws IOException {
        Path orig = this.getPathPABf();
        Path link = this.getPathPAC();
        Files.createLink(link, orig);
        Files.delete(link);
        MatcherAssert.assertThat((Object)Files.readAllBytes(orig), (Matcher)Is.is((Object)CONTENT));
    }

    @Test
    public void testHardLinkModifyOneModifiedDateOfOtherChanged() throws IOException, InterruptedException {
        Path orig = this.getPathPABf();
        Path link = this.getPathPAC();
        Files.createLink(link, orig);
        FileTime before = Files.getLastModifiedTime(orig, new LinkOption[0]);
        Thread.sleep(1000L);
        Files.write(link, CONTENT_OTHER, new OpenOption[0]);
        MatcherAssert.assertThat((Object)Files.getLastModifiedTime(orig, new LinkOption[0]), (Matcher)Matchers.greaterThan((Comparable)before));
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void testHardLinkToExistingFileThrows() throws IOException, InterruptedException {
        Path orig = this.getPathPABf();
        Path link = this.getPathPACf();
        Files.createLink(link, orig);
    }

    @Test(expected=Exception.class)
    public void testHardLinkToOtherThrows() throws IOException {
        Assume.assumeThat((Object)this.capabilities.has2ndFileSystem(), (Matcher)Is.is((Object)true));
        Path orig = this.getPathOtherPAf();
        Path link = this.getPathPAC();
        Files.createLink(link, orig);
    }

    @Test(expected=FileSystemException.class)
    public void testHardLinkToDirThrows() throws IOException {
        Path orig = this.getPathPAd();
        Path link = this.getPathPB();
        Files.createLink(link, orig);
    }

    @Test
    public void testHardLinkToHardLink() throws IOException {
        Path orig = this.getPathPABf();
        Path link = this.getPathPAC();
        Path link2 = this.getPathPA().resolve(this.nameStr[0]);
        Files.createLink(link, orig);
        Files.createLink(link2, link);
        MatcherAssert.assertThat((Object)link2, PathExists.exists());
    }

    @Test
    public void test2ndHardLink() throws IOException {
        Path orig = this.getPathPABf();
        Path link = this.getPathPAC();
        Path link2 = this.getPathPA().resolve(this.nameStr[0]);
        Files.createLink(link, orig);
        Files.createLink(link2, orig);
        MatcherAssert.assertThat((Object)link2, PathExists.exists());
    }

    @Test
    public void testIsSameFileWithHardLink() throws IOException {
        Path orig = this.getPathPABf();
        Path link = this.getPathPAC();
        Files.createLink(link, orig);
        MatcherAssert.assertThat((Object)Files.isSameFile(link, orig), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testHardLinkHasSameFileKey() throws IOException {
        Path orig = this.getPathPABf();
        Path link = this.getPathPAC();
        Files.createLink(link, orig);
        Object fk1 = Files.readAttributes(orig, BasicFileAttributes.class, new LinkOption[0]).fileKey();
        Object fk2 = Files.readAttributes(link, BasicFileAttributes.class, new LinkOption[0]).fileKey();
        MatcherAssert.assertThat((Object)fk1, (Matcher)Is.is((Object)fk2));
    }
}

