/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.lindwurm.niotest.tests.PathTest12DifferentFS;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsEmptyIterable;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Test;

public abstract class PathTest13FileStoreIT
extends PathTest12DifferentFS {
    @Test
    public void testFileStoreIterable() {
        MatcherAssert.assertThat(this.FS.getFileStores(), (Matcher)Matchers.not((Matcher)IsEmptyIterable.emptyIterable()));
    }

    @Test
    public void testFileStoresHaveAName() {
        for (FileStore store : this.FS.getFileStores()) {
            MatcherAssert.assertThat((Object)store.name(), (Matcher)Matchers.notNullValue());
        }
    }

    @Test
    public void testFileStoresHaveAType() {
        for (FileStore store : this.FS.getFileStores()) {
            MatcherAssert.assertThat((Object)store.type(), (Matcher)Matchers.notNullValue());
        }
    }

    @Test
    public void testFileStoreTotalSpaceIsNonNegative() throws IOException {
        for (FileStore store : this.FS.getFileStores()) {
            MatcherAssert.assertThat((Object)store.getTotalSpace(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
        }
    }

    @Test
    public void testFileStoreUsableSpaceIsSmallerThanTotal() throws IOException {
        for (FileStore store : this.FS.getFileStores()) {
            MatcherAssert.assertThat((Object)store.getTotalSpace(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(store.getUsableSpace())));
        }
    }

    @Test
    public void testFileStoreUnallocatedSpaceIsSmallerUsableSpace() throws IOException {
        for (FileStore store : this.FS.getFileStores()) {
            MatcherAssert.assertThat((Object)store.getUnallocatedSpace(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(store.getUsableSpace())));
        }
    }

    @Test
    public void testPathFileStoreIsOneOfGeneralOnes() throws IOException {
        MatcherAssert.assertThat(this.FS.getFileStores(), (Matcher)IsCollectionContaining.hasItem((Object)this.FS.provider().getFileStore(this.getPathPAf())));
    }

    @Test
    public void testPathFileStoreGrowingFileLowersUsableSpace() throws IOException {
        Path file = this.getPathPAf();
        FileStore store = this.FS.provider().getFileStore(file);
        long before = store.getUnallocatedSpace();
        Files.write(file, CONTENT20k, new OpenOption[0]);
        MatcherAssert.assertThat((Object)store.getUsableSpace(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(before)));
    }

    @Test
    public void testFileStoreShowsThatBasicFileAttributeViewIsSupported() throws IOException {
        FileStore store = this.FS.provider().getFileStore(this.getDefaultPath());
        Assert.assertThat((Object)store.supportsFileAttributeView(BasicFileAttributeView.class), (Matcher)CoreMatchers.is((Object)true));
    }
}

