/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.lindwurm.niotest.matcher.PathAbsolute;
import de.pfabulist.lindwurm.niotest.matcher.PathExists;
import de.pfabulist.lindwurm.niotest.tests.PathTest9WrongProviderIT;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public abstract class PathTest10PathWithContentIT
extends PathTest9WrongProviderIT {
    @Test
    public void testIsSameFileOnEqualPath() throws IOException {
        Assert.assertThat((Object)Files.isSameFile(this.getPathPA(), this.getPathPA()), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testIsSameFileOnEqualPathElementsDifferentProvider() throws IOException {
        Assume.assumeThat((Object)this.FS, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.is((Object)FileSystems.getDefault())));
        Assert.assertThat((Object)Files.isSameFile(this.getPathA(), FileSystems.getDefault().getPath(this.nameStr[0], new String[0])), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testIsSameFileWithUnnormalizedPath() throws IOException {
        Assert.assertThat((Object)this.FS.provider().isSameFile(this.getPathPABf(), this.getPathPABu()), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testIsSameFileWithRelativePath() throws IOException {
        Assert.assertThat((Object)this.FS.provider().isSameFile(this.getPathPABf(), this.getPathPABr()), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testIsSameFileOfSameContentDifferentPathIsNot() throws IOException {
        Assert.assertThat((Object)this.FS.provider().isSameFile(this.getPathPAf(), this.getPathPBf()), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test(expected=NoSuchFileException.class)
    public void testIsSameFileOfDifferentPathNonExistingFileThrows() throws IOException {
        this.FS.provider().isSameFile(this.getPathPABf(), this.getPathPB());
    }

    @Test(expected=NoSuchFileException.class)
    public void testIsSameFileOfDifferentPathNonExistingFile2Throws() throws IOException {
        this.FS.provider().isSameFile(this.getPathPA(), this.getPathPBf());
    }

    @Test
    public void testWriteUnnormalized() throws IOException {
        this.getPathPAd();
        Path read = this.getPathPAB();
        Path write = this.getPathPABu();
        Files.write(write, CONTENT, standardOpen);
        byte[] out = Files.readAllBytes(read);
        Assert.assertThat((Object)out, (Matcher)Is.is((Object)CONTENT));
    }

    @Test
    public void testReadAttributesFromUnnormalizedPath() throws IOException {
        this.getPathPABf();
        Path read = this.getPathPABu();
        Assert.assertThat((Object)Files.size(read), (Matcher)CoreMatchers.is((Object)(0L + (long)CONTENT.length)));
    }

    @Test
    public void testCheckAccessUnnormalizedPath() throws IOException {
        this.getPathPABf();
        Path read = this.getPathPABu();
        this.FS.provider().checkAccess(read, new AccessMode[0]);
    }

    @Test
    public void testCheckAccessRelativePath() throws IOException {
        this.getPathPABf();
        Path read = this.getPathPABr();
        this.FS.provider().checkAccess(read, new AccessMode[0]);
    }

    @Test
    public void testCheckAccessSupportesRead() throws IOException {
        try {
            this.FS.provider().checkAccess(this.getPathPABf(), AccessMode.READ);
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    @Test
    public void testCheckAccessSupportesWrite() throws IOException {
        try {
            this.FS.provider().checkAccess(this.getPathPABf(), AccessMode.WRITE);
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    @Test
    public void testCheckAccessSupportesExecute() throws IOException {
        try {
            this.FS.provider().checkAccess(this.getPathPABf(), AccessMode.EXECUTE);
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    @Test(expected=NoSuchFileException.class)
    public void testCheckAccessNonExistingFile() throws IOException {
        this.FS.provider().checkAccess(this.getPathPAB(), new AccessMode[0]);
    }

    @Test
    public void testCopyUnnormalizedPath() throws IOException {
        this.getPathPABf();
        this.FS.provider().copy(this.getPathPABu(), this.getPathPB(), new CopyOption[0]);
        Assert.assertThat((Object)Files.readAllBytes(this.getPathPAB()), (Matcher)CoreMatchers.is((Object)CONTENT));
    }

    @Test
    public void testMoveUnnormalizedPath() throws IOException {
        this.getPathPABf();
        this.FS.provider().move(this.getPathPABu(), this.getPathPB(), new CopyOption[0]);
        Assert.assertThat((Object)Files.readAllBytes(this.getPathPB()), (Matcher)CoreMatchers.is((Object)CONTENT));
    }

    @Test
    public void testCreateDirectoryWithRelativePath() throws IOException {
        this.getPathPAd();
        Path rel = this.getPathPABr();
        Files.createDirectory(rel, new FileAttribute[0]);
        Assert.assertThat((Object)rel, PathExists.exists());
    }

    @Test
    public void testDeleteUnnormalizedPath() throws IOException {
        Path file = this.getPathPABf();
        this.FS.provider().delete(this.getPathPABu());
        Assert.assertThat((Object)file, (Matcher)CoreMatchers.not(PathExists.exists()));
    }

    @Test
    public void testDeleteIfExistsUnnormalizedPath() throws IOException {
        Path file = this.getPathPABf();
        this.FS.provider().deleteIfExists(this.getPathPABu());
        Assert.assertThat((Object)file, (Matcher)CoreMatchers.not(PathExists.exists()));
    }

    @Test
    public void testIsHiddenUnnormalizedPath() throws IOException {
        Path file = this.getPathPABf();
        this.FS.provider().isHidden(file);
    }

    @Test
    public void testToRealpathResturnsAnAbsolutePath() throws Exception {
        this.getPathPABf();
        Assert.assertThat((Object)this.getPathPABr().toRealPath(new LinkOption[0]), PathAbsolute.absolute());
    }

    @Test
    public void testToRealpathResturnsAnNormalizedPath() throws Exception {
        this.getPathPABf();
        Path real = this.getPathPABu().toRealPath(new LinkOption[0]);
        Assert.assertThat((Object)real.normalize(), (Matcher)CoreMatchers.is((Object)real));
    }

    @Test
    public void testToRealpathIsSamePath() throws Exception {
        this.getPathPABf();
        Path path = this.getPathPABu();
        Assert.assertThat((Object)this.FS.provider().isSameFile(path.toRealPath(new LinkOption[0]), path), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test(expected=NoSuchFileException.class)
    public void testToRealpathOfNonExistingFileThrows() throws Exception {
        this.getPathPAB().toRealPath(new LinkOption[0]);
    }

    @Test
    public void testMaxFilenameHasNoEffectOfPathConstruction() throws IOException {
        this.getPathPTooLongFileName();
    }

    @Test
    public void testMaxFilenameWorks() throws IOException {
        Path loong = this.getPathPLongFileName();
        Files.createDirectories(loong.getParent(), new FileAttribute[0]);
        Files.write(loong, CONTENT, new OpenOption[0]);
    }

    @Test(expected=FileSystemException.class)
    public void testMaxFilenameWriteTooLongThrows() throws IOException {
        Path loong = this.getPathPTooLongFileName();
        Files.createDirectories(loong.getParent(), new FileAttribute[0]);
        Files.write(loong, CONTENT, new OpenOption[0]);
    }

    @Test
    public void testMaxFilenameDirWorks() throws IOException {
        Path loong = this.getPathPLongFileName();
        Files.createDirectories(loong, new FileAttribute[0]);
    }

    @Test(expected=FileSystemException.class)
    public void testMaxFilenameDirTooLongThrows() throws IOException {
        Path loong = this.getPathPTooLongFileName();
        Files.createDirectories(loong, new FileAttribute[0]);
    }

    @Test
    public void testMaxFilenameCopyWorks() throws IOException {
        Path loong = this.getPathPLongFileName();
        Files.copy(this.getPathPABf(), loong, new CopyOption[0]);
    }

    @Test(expected=FileSystemException.class)
    public void testMaxFilenameCopyTooLongThrows() throws IOException {
        Path loong = this.getPathPTooLongFileName();
        Files.copy(this.getPathPABf(), loong, new CopyOption[0]);
    }

    @Test
    public void testMaxFilenameHardLinkWorks() throws IOException {
        Path loong = this.getPathPLongFileName();
        Files.createLink(loong, this.getPathPABf());
    }

    @Test(expected=FileSystemException.class)
    public void testMaxFilenameHardLinkTooLongThrows() throws IOException {
        Path loong = this.getPathPTooLongFileName();
        Files.createLink(loong, this.getPathPABf());
    }

    @Test
    public void testMaxFilenameMoveWorks() throws IOException {
        Path loong = this.getPathPLongFileName();
        Files.move(this.getPathPABf(), loong, new CopyOption[0]);
    }

    @Test(expected=FileSystemException.class)
    public void testMaxFilenameMoveTooLongThrows() throws IOException {
        Path loong = this.getPathPTooLongFileName();
        Files.move(this.getPathPABf(), loong, new CopyOption[0]);
    }

    @Test(expected=FileSystemException.class)
    public void testMaxFilenameMsdaoveTooLongThrows() throws IOException {
        Path loong = this.getPathPTooLongFileName();
        Files.move(this.getPathPABf(), loong, new CopyOption[0]);
    }

    private DirectoryStream.Filter<Path> getFilterAll() {
        return new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                return true;
            }
        };
    }
}

