/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.kleinod.errors.Runnnable;
import de.pfabulist.kleinod.paths.Filess;
import de.pfabulist.kleinod.text.Strings;
import de.pfabulist.lindwurm.niotest.tests.ClosedFSVars;
import de.pfabulist.lindwurm.niotest.tests.FSCapabilities;
import de.pfabulist.lindwurm.niotest.tests.PathTestIT;
import de.pfabulist.lindwurm.niotest.tests.SymLinkDescriptionBuilder;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class FSDescription
implements FSCapabilities {
    private final PathTestIT setup;
    private boolean closable = true;
    private boolean hasLinks = true;
    boolean hasSymbolicLinks = true;
    private boolean hasAsynchronousFileChannels = true;
    private boolean hasFileChannels = true;
    private boolean supportsCreationTime = true;
    private boolean supportsLastAccessTime = true;
    boolean supportsWatchService = true;
    private boolean has2ndFileSystem = true;
    private boolean filestores = false;
    private Runnnable shake = () -> {};
    private Function<FileSystem, URI> toURI = FSDescription::toURIWithRoot;
    private Collection<Character> pathIllegalCharacters = Collections.emptyList();
    private boolean principals = false;
    private boolean hasSizeLimitedFileSystem = false;
    private boolean supportsPosixAttributes = false;
    private Path otherRoot;
    private boolean windows = false;
    private boolean canSeeLocalUNCSharesSet;
    private boolean canSeeLocalUNCShares;
    private int maxFilenameLength = 255;
    private List<String> illegalFilenames = new ArrayList<String>();
    private boolean fileChannels = false;
    boolean supportsForeignSymLinks = true;
    public boolean hasDirSymLinks = true;
    public boolean delayedSymLinkLoopChecking = false;
    public boolean immediateSymLinkLoopChecking = true;
    int watcherSleepTime = 1200;

    FSDescription(PathTestIT setup) {
        this.setup = setup;
    }

    public FSDescription playground(Path path) {
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("need absolute path");
        }
        this.setup.setPlay(path);
        return this;
    }

    public FSDescription secondPlayground(Path path) {
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("need absolute path");
        }
        this.setup.play2 = path;
        if (path == null) {
            this.has2ndFileSystem = false;
        }
        return this;
    }

    public FSDescription noSecondPlayground() {
        this.has2ndFileSystem = false;
        return this;
    }

    public FSDescription notClosable() {
        this.closable = false;
        return this;
    }

    public FSDescription fileStores(boolean fs) {
        this.filestores = fs;
        return this;
    }

    public FSDescription lastAccessTime(boolean la) {
        this.supportsLastAccessTime = la;
        return this;
    }

    @Override
    public boolean isClosable() {
        return this.closable;
    }

    @Override
    public boolean hasLinks() {
        return this.hasLinks;
    }

    @Override
    public boolean hasSymbolicLinks() {
        return this.hasSymbolicLinks;
    }

    @Override
    public boolean hasAsynchronousFileChannels() {
        return this.hasAsynchronousFileChannels;
    }

    @Override
    public boolean hasFileChannels() {
        return this.hasFileChannels;
    }

    @Override
    public boolean supportsCreationTime() {
        return this.supportsCreationTime;
    }

    public FSDescription creationTime(boolean ct) {
        this.supportsCreationTime = ct;
        return this;
    }

    @Override
    public boolean supportsLastAccessTime() {
        return this.supportsLastAccessTime;
    }

    public FSDescription lastAccessTime() {
        this.supportsLastAccessTime = false;
        return this;
    }

    @Override
    public boolean supportsWatchService() {
        return this.supportsWatchService;
    }

    public WatchServiceBuilder watchService() {
        return new WatchServiceBuilder(this);
    }

    public FSDescription noLinks() {
        this.hasLinks = false;
        return this;
    }

    public FSDescription noSymLinks() {
        this.hasSymbolicLinks = false;
        return this;
    }

    public FSDescription noAsynchronousFileChannels() {
        this.hasAsynchronousFileChannels = false;
        return this;
    }

    public FSDescription noFileChannels() {
        this.hasFileChannels = false;
        return this;
    }

    public FSDescription shake(Runnnable f) {
        this.shake = f;
        return this;
    }

    @Override
    public boolean supportsFileStores() {
        return this.filestores;
    }

    @Override
    public boolean has2ndFileSystem() {
        return this.has2ndFileSystem;
    }

    @Override
    public boolean hasSizeLimitedFileSystem() {
        return this.hasSizeLimitedFileSystem;
    }

    @Override
    public Runnnable shake() {
        return this.shake;
    }

    @Override
    public Function<FileSystem, URI> toURI() {
        return this.toURI;
    }

    @Override
    public Collection<Character> getPathIllegalCharacters() {
        return this.pathIllegalCharacters;
    }

    @Override
    public Collection<String> getIllegalFilenames() {
        return this.illegalFilenames;
    }

    @Override
    public boolean supportsFileChannels() {
        return this.fileChannels;
    }

    @Override
    public boolean supportsForeignSymLinks() {
        return this.supportsForeignSymLinks;
    }

    @Override
    public int getWatcherSleepTime() {
        return this.watcherSleepTime;
    }

    @Override
    public boolean supportsPrincipals() {
        return this.principals;
    }

    @Override
    public boolean supportsPosixAttributes() {
        return this.supportsPosixAttributes;
    }

    @Override
    public Path getOtherRoot() {
        return this.otherRoot;
    }

    @Override
    public boolean hasOtherRoot() {
        return this.otherRoot != null;
    }

    @Override
    public boolean isWindows() {
        return this.windows;
    }

    @Override
    public boolean canSeeLocalUNCShares(FileSystem fs) {
        if (!this.isWindows()) {
            return false;
        }
        if (!this.canSeeLocalUNCSharesSet) {
            this.canSeeLocalUNCShares = Files.exists(fs.getPath("\\\\localhost\\C$", new String[0]), new LinkOption[0]);
            this.canSeeLocalUNCSharesSet = true;
        }
        return this.canSeeLocalUNCShares;
    }

    @Override
    public int getMaxFilenameLength() {
        return this.maxFilenameLength;
    }

    public static URI toURIWithRoot(FileSystem fs) {
        URI ret = fs.getPath("", new String[0]).toAbsolutePath().getRoot().toUri();
        return ret;
    }

    public static URI toURIWithoutPath(FileSystem fs) {
        Path root = fs.getPath("", new String[0]).toAbsolutePath().getRoot();
        return URI.create(Strings.withoutSuffix((String)root.toUri().toString(), (String)root.toString()));
    }

    public FSDescription bug(String method) {
        this.setup.notSupported.put(method, "");
        return this;
    }

    public FSDescription closablePlayground(ClosedFSVars closedVars) {
        this.setup.setClosablePlay(closedVars);
        return this;
    }

    public FSDescription fileSystemURI(Function<FileSystem, URI> func) {
        this.toURI = func;
        return this;
    }

    public FSDescription unix() {
        this.pathIllegalCharacters = Arrays.asList(Character.valueOf('\u0000'));
        this.principals = true;
        this.doesSupportPosixAttributes(true);
        return this;
    }

    public FSDescription unix(boolean on) {
        if (on) {
            return this.unix();
        }
        return this;
    }

    public FSDescription pathIllegalCharacters(Character ... getPathIllegalCharacters) {
        this.pathIllegalCharacters = Arrays.asList(getPathIllegalCharacters);
        return this;
    }

    public FSDescription principals(boolean p) {
        this.principals = p;
        return this;
    }

    public FSDescription sizeLimitedPlayground(Path limitedPlayground) {
        this.hasSizeLimitedFileSystem = true;
        this.setup.sizeLimitedPlayground = limitedPlayground;
        Filess.createDirectories((Path)limitedPlayground);
        return this;
    }

    public FSDescription doesSupportPosixAttributes(boolean on) {
        this.supportsPosixAttributes = on;
        return this;
    }

    public FSDescription otherRoot(Path path) {
        this.otherRoot = path;
        return this;
    }

    public FSDescription alternativeNames(String ... alt) {
        this.setup.nameStrCase = alt;
        return this;
    }

    public FSDescription windows(boolean on) {
        this.windows = on;
        this.setIllegalFilenames("nul", "com");
        this.pathIllegalCharacters(Character.valueOf(':'), Character.valueOf('|'), Character.valueOf('\"'));
        return this;
    }

    public FSDescription setMaxFilenameLength(int maxFilenameLength) {
        this.maxFilenameLength = maxFilenameLength;
        return this;
    }

    public FSDescription setIllegalFilenames(String ... ill) {
        this.illegalFilenames = Arrays.asList(ill);
        return this;
    }

    public FSDescription fileChannels(boolean val) {
        this.fileChannels = val;
        return this;
    }

    public FSDescription doesNotSupporForeignSymLinks() {
        this.supportsForeignSymLinks = false;
        return this;
    }

    public SymLinkDescriptionBuilder symLinks() {
        return new SymLinkDescriptionBuilder(this);
    }

    public static class WatchServiceBuilder {
        private final FSDescription fsDescription;

        public WatchServiceBuilder(FSDescription fsDescription) {
            this.fsDescription = fsDescription;
        }

        public FSDescription no() {
            this.fsDescription.supportsWatchService = false;
            return this.fsDescription;
        }

        public FSDescription yes() {
            this.fsDescription.supportsWatchService = true;
            return this.fsDescription;
        }

        public WatchServiceBuilder sleepTime(int seconds) {
            this.fsDescription.watcherSleepTime = seconds;
            return this;
        }
    }
}

