/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.kleinod.errors.Unchecked;
import de.pfabulist.lindwurm.niotest.matcher.PathExists;
import de.pfabulist.lindwurm.niotest.matcher.PathIsDirectory;
import de.pfabulist.lindwurm.niotest.tests.PathTest19HardLinksIT;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotLinkException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Test;

public abstract class PathTest20SymLinksIT
extends PathTest19HardLinksIT {
    @Test
    public void testCreateSymLink() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetFile(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)this.link(), PathExists.exists());
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void testCreateSymLinkWhereLinkExistsThrows() throws IOException {
        Files.write(this.link(), CONTENT, new OpenOption[0]);
        Files.createSymbolicLink(this.link(), this.targetFile(), new FileAttribute[0]);
    }

    @Test
    public void testSymLinkAttributeNonLink() throws IOException {
        MatcherAssert.assertThat((Object)Files.isSymbolicLink(this.targetFile()), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testSymLinkAttributeLink() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetDir(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)Files.isSymbolicLink(this.link()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testReadFromSymLink() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetFile(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.link()), (Matcher)Is.is((Object)CONTENT));
    }

    @Test
    public void testReadFromSymLinkToSymLink() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetFile(), new FileAttribute[0]);
        Files.createSymbolicLink(this.link2(), this.link(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.link2()), (Matcher)Is.is((Object)CONTENT));
    }

    @Test
    public void testWriteToSymLink() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetFile(), new FileAttribute[0]);
        Files.write(this.link(), CONTENT_OTHER, new OpenOption[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.targetFile()), (Matcher)Is.is((Object)CONTENT_OTHER));
    }

    @Test
    public void testDirSymLink() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetDir(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)Files.isDirectory(this.link(), new LinkOption[0]), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testDirStreamFromSymLink() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetDir(), new FileAttribute[0]);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.link());){
            for (Path kid : stream) {
                System.out.println(kid);
                MatcherAssert.assertThat((Object)kid.getParent(), (Matcher)Is.is((Object)this.link()));
                MatcherAssert.assertThat((Object)Files.isSameFile(kid, this.targetDirKid()), (Matcher)Is.is((Object)true));
            }
        }
    }

    @Test
    public void testCreateFileInSymLinkDir() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetDir(), new FileAttribute[0]);
        Files.write(this.linkKid(), CONTENT, new OpenOption[0]);
        MatcherAssert.assertThat((Object)this.linkKid(), PathExists.exists());
    }

    @Test
    public void testFileInSymLinkDirIsNotSymLink() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetDir(), new FileAttribute[0]);
        Files.write(this.linkKid(), CONTENT, new OpenOption[0]);
        MatcherAssert.assertThat((Object)Files.isSymbolicLink(this.linkKid()), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testCreateDirInSymLinkDir() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetDir(), new FileAttribute[0]);
        Files.createDirectory(this.linkKid(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)this.linkKid(), PathIsDirectory.isDirectory());
    }

    @Test
    public void testDeleteSymLinkDoesNotDeleteTarget() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetFile(), new FileAttribute[0]);
        Files.delete(this.link());
        MatcherAssert.assertThat((Object)this.targetFile(), PathExists.exists());
    }

    @Test
    public void testCopyFromSymLink() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetFile(), new FileAttribute[0]);
        Files.copy(this.link(), this.copyTarget(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.copyTarget()), (Matcher)Is.is((Object)CONTENT));
    }

    @Test
    public void testCopyFromDeeperSymLink() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetDir(), new FileAttribute[0]);
        Files.write(this.linkKid(), CONTENT, new OpenOption[0]);
        Files.copy(this.linkKid(), this.copyTarget(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.copyTarget()), (Matcher)Is.is((Object)CONTENT));
    }

    @Test
    public void testCopyToSymLink() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetFile(), new FileAttribute[0]);
        Files.copy(this.someOtherFile(), this.link(), StandardCopyOption.REPLACE_EXISTING);
        MatcherAssert.assertThat((Object)Files.isSymbolicLink(this.link()), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testCopyToDeepSymLink() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetDir(), new FileAttribute[0]);
        Files.write(this.linkKid(), CONTENT, new OpenOption[0]);
        Files.copy(this.someOtherFile(), this.linkKid(), StandardCopyOption.REPLACE_EXISTING);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.linkKid()), (Matcher)Is.is((Object)CONTENT_OTHER));
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.linkKid().toRealPath(new LinkOption[0])), (Matcher)Is.is((Object)CONTENT_OTHER));
    }

    @Test
    public void testHardLinkToSymLink() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetFile(), new FileAttribute[0]);
        Files.createLink(this.link2(), this.link());
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.link2()), (Matcher)Is.is((Object)CONTENT));
    }

    @Test
    public void testHardLinkToSymLinkIsSymLink() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetFile(), new FileAttribute[0]);
        Files.createLink(this.link2(), this.link());
        MatcherAssert.assertThat((Object)Files.isSymbolicLink(this.link2()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testHardLinkToSymLinkDeleteSym() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetFile(), new FileAttribute[0]);
        Files.createLink(this.link2(), this.link());
        MatcherAssert.assertThat((Object)Files.isSymbolicLink(this.link2()), (Matcher)Is.is((Object)true));
        Files.delete(this.link());
        Files.write(this.link2(), CONTENT_OTHER, new OpenOption[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.targetFile()), (Matcher)Is.is((Object)CONTENT_OTHER));
        MatcherAssert.assertThat((Object)Files.isSymbolicLink(this.link2()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testModifyHardLinkToSymLink() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetFile(), new FileAttribute[0]);
        Files.createLink(this.link2(), this.link());
        MatcherAssert.assertThat((Object)Files.isSymbolicLink(this.link2()), (Matcher)Is.is((Object)true));
        Files.write(this.link2(), CONTENT_OTHER, new OpenOption[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.targetFile()), (Matcher)Is.is((Object)CONTENT_OTHER));
        MatcherAssert.assertThat((Object)Files.isSymbolicLink(this.link2()), (Matcher)Is.is((Object)true));
    }

    @Test(expected=FileSystemException.class)
    public void testSymLinkToParent() throws IOException {
        Files.createSymbolicLink(this.link(), this.link().getParent(), new FileAttribute[0]);
    }

    @Test(expected=FileSystemException.class)
    public void testSymLinkComplexLoop() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetDir(), new FileAttribute[0]);
        Files.createSymbolicLink(this.targetDir().resolve(this.nameStr[5]), this.link(), new FileAttribute[0]);
    }

    @Test(expected=NoSuchFileException.class)
    public void testBrokenSymLink() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetFile(), new FileAttribute[0]);
        Files.delete(this.targetFile());
        Files.readAllBytes(this.link());
    }

    @Test
    public void testBrokenSymLinkExists() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetFile(), new FileAttribute[0]);
        Files.delete(this.targetFile());
        Files.exists(this.link(), new LinkOption[0]);
    }

    @Test
    public void testGetSymLinkTarget() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetFile(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)Files.readSymbolicLink(this.link()), (Matcher)Is.is((Object)this.targetFile()));
    }

    @Test(expected=NotLinkException.class)
    public void testGetSymLinkOfNonLinkThrows() throws IOException {
        Files.readSymbolicLink(this.targetFile());
    }

    @Test
    public void testReadAttributesFromSymLinkNoFollowLinks() throws IOException, InterruptedException {
        this.targetFile();
        Thread.sleep(2000L);
        Files.createSymbolicLink(this.link(), this.targetFile(), new FileAttribute[0]);
        FileTime orig = Files.readAttributes(this.link(), BasicFileAttributes.class, new LinkOption[0]).creationTime();
        FileTime linkTime = Files.readAttributes(this.link(), BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS).creationTime();
        MatcherAssert.assertThat((Object)linkTime, (Matcher)Matchers.greaterThan((Comparable)orig));
    }

    @Test
    public void testAttributesFromSymLinkWithFollowLinkShowNoLink() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetFile(), new FileAttribute[0]);
        BasicFileAttributes bfa = Files.readAttributes(this.link(), BasicFileAttributes.class, new LinkOption[0]);
        MatcherAssert.assertThat((Object)bfa.isSymbolicLink(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testAttributesFromSymLinkWithFollowLinkShowNoLink_View() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetFile(), new FileAttribute[0]);
        BasicFileAttributeView bfav = Files.getFileAttributeView(this.link(), BasicFileAttributeView.class, new LinkOption[0]);
        MatcherAssert.assertThat((Object)bfav.readAttributes().isSymbolicLink(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testMoveSymLinkFileTestContent() throws IOException {
        Path target = this.getPathPABf();
        Path sym = this.getPathPB();
        Path newPath = this.getPathPC().resolve(this.nameStr[1]);
        Files.createDirectory(newPath.getParent(), new FileAttribute[0]);
        Files.createSymbolicLink(sym, target, new FileAttribute[0]);
        Files.move(sym, newPath, new CopyOption[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(newPath), (Matcher)Is.is((Object)CONTENT));
    }

    @Test
    public void testMoveSymLinkFileOrigIsGone() throws IOException {
        Path target = this.getPathPABf();
        Path sym = this.getPathPB();
        Path newPath = this.getPathPC().resolve(this.nameStr[1]);
        Files.createDirectory(newPath.getParent(), new FileAttribute[0]);
        Files.createSymbolicLink(sym, target, new FileAttribute[0]);
        Files.move(sym, newPath, new CopyOption[0]);
        MatcherAssert.assertThat((Object)sym, (Matcher)IsNot.not(PathExists.exists()));
    }

    @Test
    public void testMoveSymLinkFileKeepsSymLinkStatus() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetFile(), new FileAttribute[0]);
        Files.move(this.link(), this.copyTarget(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)Files.isSymbolicLink(this.copyTarget()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testFileStoreOfSymLinkIsTargets() throws IOException {
        Path target = this.getPathPABf();
        Path sym = this.getPathPB();
        Files.createSymbolicLink(sym, target, new FileAttribute[0]);
        MatcherAssert.assertThat((Object)Files.getFileStore(sym), (Matcher)Is.is((Object)Files.getFileStore(target)));
    }

    @Test
    public void testSymLinkAndTargetAreSameFile() throws IOException {
        Path target = this.getPathPABf();
        Path sym = this.getPathPB();
        Files.createSymbolicLink(sym, target, new FileAttribute[0]);
        MatcherAssert.assertThat((Object)Files.isSameFile(sym, target), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testDeeperSymLinkIsSameFile() throws IOException {
        Path target = this.getPathPABf();
        Path sym = this.getPathPB();
        Files.createSymbolicLink(sym, target, new FileAttribute[0]);
        MatcherAssert.assertThat((Object)Files.isSameFile(sym, target), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testForeignSymLinkExists() throws IOException {
        Files.createSymbolicLink(this.link(), this.foreignTargetFile(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)this.link(), PathExists.exists());
    }

    @Test
    public void testDoubleSymLinkExists() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetDir(), new FileAttribute[0]);
        Files.createSymbolicLink(this.linkKid(), this.someOtherFile(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)this.linkKid(), PathExists.exists());
    }

    @Test
    public void testDoubleSymLinkSameFile() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetDir(), new FileAttribute[0]);
        Files.createSymbolicLink(this.linkKid(), this.someOtherFile(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)Files.isSameFile(this.linkKid(), this.someOtherFile()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testDoubleSymLinkReadAttributes() throws IOException, InterruptedException {
        this.someOtherFile();
        Thread.sleep(1100L);
        Files.createSymbolicLink(this.link(), this.targetDir(), new FileAttribute[0]);
        Files.createSymbolicLink(this.linkKid(), this.someOtherFile(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)Files.readAttributes(this.linkKid(), "basic:lastModifiedTime", new LinkOption[0]).get("lastModifiedTime"), (Matcher)Is.is((Object)Files.readAttributes(this.someOtherFile(), "basic:lastModifiedTime", new LinkOption[0]).get("lastModifiedTime")));
    }

    @Test
    public void testDeepSymLinkMove() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetDir(), new FileAttribute[0]);
        Files.write(this.linkKid(), CONTENT, new OpenOption[0]);
        Files.move(this.linkKid(), this.copyTarget(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.copyTarget()), (Matcher)Is.is((Object)CONTENT));
    }

    @Test
    public void testMoveToDeepSymLink() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetDir(), new FileAttribute[0]);
        Files.move(this.someOtherFile(), this.linkKid(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.linkKid()), (Matcher)Is.is((Object)CONTENT_OTHER));
    }

    @Test
    public void testDoubleSymLinkReadAttributesNoFollowLink() throws IOException, InterruptedException {
        this.someOtherFile();
        Thread.sleep(1100L);
        Files.createSymbolicLink(this.link(), this.targetDir(), new FileAttribute[0]);
        Files.createSymbolicLink(this.linkKid(), this.someOtherFile(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)((FileTime)Files.readAttributes(this.linkKid(), "basic:lastModifiedTime", LinkOption.NOFOLLOW_LINKS).get("lastModifiedTime")), (Matcher)Matchers.greaterThan((Comparable)((FileTime)Files.readAttributes(this.someOtherFile(), "basic:lastModifiedTime", new LinkOption[0]).get("lastModifiedTime"))));
    }

    @Test
    public void testReadFromForeignSymLink() throws IOException {
        Files.createSymbolicLink(this.link(), this.foreignTargetFile(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.link()), (Matcher)Is.is((Object)CONTENT));
    }

    @Test
    public void testGetForeignSymLinkTarget() throws IOException {
        Files.createSymbolicLink(this.link(), this.foreignTargetFile(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)Files.readSymbolicLink(this.link()), (Matcher)Is.is((Object)this.foreignTargetFile()));
    }

    @Test
    public void testGetDirStreamFromForeignSymLink() throws IOException {
        Files.createSymbolicLink(this.link(), this.foreignTargetDir(), new FileAttribute[0]);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.link());){
            for (Path kid : stream) {
                MatcherAssert.assertThat((Object)Files.readAllBytes(kid), (Matcher)Is.is((Object)CONTENT));
            }
        }
    }

    @Test
    public void testIsSameFileForeignSymLink() throws IOException {
        Files.createSymbolicLink(this.link(), this.foreignTargetFile(), new FileAttribute[0]);
        Files.createSymbolicLink(this.link2(), this.foreignTargetFile(), new FileAttribute[0]);
        MatcherAssert.assertThat((Object)Files.isSameFile(this.link(), this.link2()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testSymLinkChanges() throws IOException {
        Files.createSymbolicLink(this.link(), this.targetFile(), new FileAttribute[0]);
        Files.delete(this.targetFile());
        this.targetDir();
        MatcherAssert.assertThat((Object)this.link(), PathIsDirectory.isDirectory());
    }

    @Test
    public void testMoveToDeepForeignSymLink() throws IOException {
        Files.createSymbolicLink(this.link(), this.foreignTargetDir(), new FileAttribute[0]);
        Files.move(this.someOtherFile(), this.linkKid(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.linkKid()), (Matcher)Is.is((Object)CONTENT_OTHER));
    }

    private Path targetFile() {
        try {
            Path target = this.getPathPAB();
            if (Files.exists(target, new LinkOption[0])) {
                return target;
            }
            return this.getPathPABf();
        }
        catch (IOException e) {
            throw Unchecked.runtime((Exception)e);
        }
    }

    private Path foreignTargetFile() {
        try {
            Path target = this.getForeignPathP().resolve(this.nameStr[0]).resolve(this.nameStr[0]);
            if (!Files.exists(target, new LinkOption[0])) {
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                Files.write(target, CONTENT, new OpenOption[0]);
            }
            return target;
        }
        catch (IOException e) {
            throw Unchecked.runtime((Exception)e);
        }
    }

    private Path foreignTargetDir() {
        try {
            Path target = this.getForeignPathP().resolve(this.nameStr[0]).resolve(this.nameStr[0]);
            if (!Files.exists(target, new LinkOption[0])) {
                Files.createDirectories(target, new FileAttribute[0]);
                Files.write(this.foreignTargetDirKid(), CONTENT, new OpenOption[0]);
            }
            return target;
        }
        catch (IOException e) {
            throw Unchecked.runtime((Exception)e);
        }
    }

    private Path targetDir() {
        try {
            Path target = this.getPathPAB();
            if (!Files.exists(target, new LinkOption[0])) {
                Files.createDirectories(target, new FileAttribute[0]);
                Files.write(this.targetDirKid(), CONTENT, new OpenOption[0]);
            }
            return target;
        }
        catch (IOException e) {
            throw Unchecked.runtime((Exception)e);
        }
    }

    private Path someOtherFile() {
        try {
            Path ret = this.getPathPA().resolve(this.nameStr[4]);
            if (!Files.exists(ret, new LinkOption[0])) {
                Files.createDirectories(ret.getParent(), new FileAttribute[0]);
                Files.write(ret, CONTENT_OTHER, new OpenOption[0]);
            }
            return ret;
        }
        catch (IOException e) {
            throw Unchecked.runtime((Exception)e);
        }
    }

    private Path targetDirKid() {
        try {
            return this.getPathPAB().resolve(this.nameStr[0]);
        }
        catch (IOException e) {
            throw Unchecked.runtime((Exception)e);
        }
    }

    private Path foreignTargetDirKid() {
        return this.getForeignPathP().resolve(this.nameStr[0]).resolve(this.nameStr[0]).resolve(this.nameStr[1]);
    }

    private Path link() {
        try {
            Files.createDirectories(this.getPathPB(), new FileAttribute[0]);
            return this.getPathPB().resolve(this.getName("link"));
        }
        catch (IOException e) {
            throw Unchecked.runtime((Exception)e);
        }
    }

    private Path link2() {
        try {
            return this.getPathPB().resolve(this.nameStr[3]);
        }
        catch (IOException e) {
            throw Unchecked.runtime((Exception)e);
        }
    }

    private Path linkKid() {
        return this.link().resolve(this.getName("linkKid"));
    }

    private Path copyTarget() {
        try {
            Path target = this.getPathPC().resolve(this.nameStr[4]);
            if (!Files.exists(target.getParent(), new LinkOption[0])) {
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
            }
            return target;
        }
        catch (IOException e) {
            throw Unchecked.runtime((Exception)e);
        }
    }
}

