/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.lindwurm.niotest.tests.PathTest15LimitedFileStoreIT;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.UserPrincipal;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public abstract class PathTest16PosixIT
extends PathTest15LimitedFileStoreIT {
    @Test
    public void testDefaultOwnerIsFoundInLookpupService() throws IOException {
        Assume.assumeThat((Object)this.capabilities.supportsPrincipals(), (Matcher)Matchers.is((Object)true));
        Assume.assumeThat((Object)this.capabilities.supportsPosixAttributes(), (Matcher)Matchers.is((Object)true));
        UserPrincipal owner = Files.readAttributes(this.getDefaultPath(), PosixFileAttributes.class, new LinkOption[0]).owner();
        Assert.assertThat((Object)owner, (Matcher)Matchers.is((Object)this.FS.getUserPrincipalLookupService().lookupPrincipalByName(owner.getName())));
    }

    @Test
    public void testOwnerByTwoMethods() throws IOException {
        Assume.assumeThat((Object)this.capabilities.supportsPrincipals(), (Matcher)Matchers.is((Object)true));
        Assume.assumeThat((Object)this.capabilities.supportsPosixAttributes(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)Files.getOwner(this.getDefaultPath(), new LinkOption[0]), (Matcher)Matchers.is((Object)Files.readAttributes(this.getDefaultPath(), PosixFileAttributes.class, new LinkOption[0]).owner()));
    }

    @Test
    public void testPosixGetAttributeViewOfNonExistingFile() throws IOException {
        Assume.assumeThat((Object)this.capabilities.supportsPosixAttributes(), (Matcher)Matchers.is((Object)true));
        PosixFileAttributes pfa = Files.readAttributes(this.getPathPA(), PosixFileAttributes.class, new LinkOption[0]);
        Assert.assertThat((Object)pfa, (Matcher)Matchers.notNullValue());
    }
}

