/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.lindwurm.niotest.tests.PathTest14Principals;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assume;
import org.junit.Test;

public abstract class PathTest15LimitedFileStoreIT
extends PathTest14Principals {
    @Test
    public void testAAA15() throws IOException {
        Assume.assumeThat((Object)this.capabilities.supportsFileStores(), (Matcher)Is.is((Object)true));
        Assume.assumeThat((Object)this.capabilities.hasSizeLimitedFileSystem(), (Matcher)Is.is((Object)true));
        FileStore store = this.sizeLimitedPlayground.getFileSystem().provider().getFileStore(this.sizeLimitedPlayground);
        long limit = store.getUnallocatedSpace();
        MatcherAssert.assertThat((Object)limit, (Matcher)Matchers.lessThan((Comparable)Long.valueOf(15000L)));
        Assume.assumeThat((Object)limit, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(1000L)));
    }

    @Test
    public void testCanCreateFileWithinLimits() throws IOException {
        Assume.assumeThat((Object)this.capabilities.supportsFileStores(), (Matcher)Is.is((Object)true));
        Assume.assumeThat((Object)this.capabilities.hasSizeLimitedFileSystem(), (Matcher)Is.is((Object)true));
        FileStore store = this.sizeLimitedPlayground.getFileSystem().provider().getFileStore(this.sizeLimitedPlayground);
        Path file = this.sizeLimitedPlayground.resolve(this.nameStr[0]);
        Files.write(file, CONTENT, new OpenOption[0]);
    }

    @Test(expected=IOException.class)
    public void testCanNotCreateFileToExeedStore() throws IOException {
        Assume.assumeThat((Object)this.capabilities.supportsFileStores(), (Matcher)Is.is((Object)true));
        Assume.assumeThat((Object)this.capabilities.hasSizeLimitedFileSystem(), (Matcher)Is.is((Object)true));
        FileStore store = this.sizeLimitedPlayground.getFileSystem().provider().getFileStore(this.sizeLimitedPlayground);
        long before = store.getUnallocatedSpace();
        Assume.assumeThat((Object)before, (Matcher)Matchers.lessThan((Comparable)Long.valueOf(15000L)));
        Path file = this.sizeLimitedPlayground.resolve(this.nameStr[0]);
        Files.write(file, CONTENT20k, new OpenOption[0]);
    }

    @Test(expected=IOException.class)
    public void testCanNotModifyFileToExeedStore() throws IOException {
        Assume.assumeThat((Object)this.capabilities.supportsFileStores(), (Matcher)Is.is((Object)true));
        Assume.assumeThat((Object)this.capabilities.hasSizeLimitedFileSystem(), (Matcher)Is.is((Object)true));
        FileStore store = this.sizeLimitedPlayground.getFileSystem().provider().getFileStore(this.sizeLimitedPlayground);
        long before = store.getUnallocatedSpace();
        Path file = this.sizeLimitedPlayground.resolve(this.nameStr[0]);
        Assume.assumeThat((Object)before, (Matcher)Matchers.lessThan((Comparable)Long.valueOf(15000L)));
        Assume.assumeThat((Object)before, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(1000L)));
        Files.write(file, CONTENT, new OpenOption[0]);
        Files.write(file, CONTENT20k, new OpenOption[0]);
    }
}

