/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.lindwurm.niotest.matcher.PathExists;
import de.pfabulist.lindwurm.niotest.matcher.WatchKeyMatcher;
import de.pfabulist.lindwurm.niotest.tests.PathTest11WatcherIT;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.attribute.FileAttribute;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.Assume;
import org.junit.Test;

public abstract class PathTest12DifferentFS
extends PathTest11WatcherIT {
    protected Path play2;

    @Test
    public void testAAA12() {
        Assume.assumeThat((Object)this.capabilities.has2ndFileSystem(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.play2, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)this.FS.provider(), (Matcher)CoreMatchers.is((Object)this.play2.getFileSystem().provider()));
        MatcherAssert.assertThat((Object)this.FS, (Matcher)IsNot.not((Matcher)CoreMatchers.is((Object)this.play2.getFileSystem())));
    }

    @Test
    public void testCopyDifferentFS() throws IOException {
        Assume.assumeThat((Object)this.capabilities.has2ndFileSystem(), (Matcher)CoreMatchers.is((Object)true));
        Path src = this.getPathPABf();
        this.FS.provider().copy(src, this.getPathOtherPA(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)this.getPathOtherPA(), PathExists.exists());
    }

    @Test
    public void testIsSameFileDifferentFS() throws IOException {
        Assume.assumeThat((Object)this.capabilities.has2ndFileSystem(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.FS.provider().isSameFile(this.getPathPAf(), this.getPathOtherPAf()), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testMoveDifferentFS() throws IOException {
        Assume.assumeThat((Object)this.capabilities.has2ndFileSystem(), (Matcher)CoreMatchers.is((Object)true));
        Path src = this.getPathPABf();
        this.FS.provider().move(src, this.getPathOtherPA(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)this.getPathOtherPA(), PathExists.exists());
        MatcherAssert.assertThat((Object)src, (Matcher)IsNot.not(PathExists.exists()));
    }

    @Test
    public void testWatchACreateFromCopyFromOtherFS() throws Exception {
        Assume.assumeThat((Object)this.play2, (Matcher)CoreMatchers.notNullValue());
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        Files.copy(this.getPathOtherPAf(), this.getPathWA(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)this.waitForWatchService().poll(), WatchKeyMatcher.correctKey(this.getPathWA(), StandardWatchEventKinds.ENTRY_CREATE));
    }

    @Test
    public void testWatchACreateFromMoveFromOtherFS() throws Exception {
        Assume.assumeThat((Object)this.play2, (Matcher)CoreMatchers.notNullValue());
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        Files.move(this.getPathOtherPAf(), this.getPathWA(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)this.waitForWatchService().poll(), WatchKeyMatcher.correctKey(this.getPathWA(), StandardWatchEventKinds.ENTRY_CREATE));
    }

    public Path getPathOtherPA() throws IOException {
        Path dir = this.play2.resolve(this.testMethodName.getMethodName());
        Files.createDirectories(dir, new FileAttribute[0]);
        return dir.resolve(this.nameStr[0]);
    }

    public Path getPathOtherPAf() throws IOException {
        Path dir = this.play2.resolve(this.testMethodName.getMethodName());
        Files.createDirectories(dir, new FileAttribute[0]);
        Path ret = dir.resolve(this.nameStr[0]);
        Files.write(ret, CONTENT, standardOpen);
        return ret;
    }
}

