package de.pfabulist.lindwurm.memoryntfs;


import de.pfabulist.kleinod.paths.Pathss;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static de.pfabulist.kleinod.errors.Unchecked.runtime;
import static de.pfabulist.lindwurm.memory.MemoryConstants.*;

/**
 * ** BEGIN LICENSE BLOCK *****
 * BSD License (2 clause)
 * Copyright (c) 2006 - 2014, Stephan Pfab
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL Stephan Pfab BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * **** END LICENSE BLOCK ****
 */
public class MemoryNTFSBuilder {

    private boolean closable = true;
    private boolean watchService = true;
    private long    maxSize;
    private String name;
    private List<Character> drives = new ArrayList<>();

    public static MemoryNTFSBuilder memoryNTFS() {
        return new MemoryNTFSBuilder();
    }

    public FileSystem build()  {
        Map<String, Object> vars = new HashMap<>();

        if (watchService) {
            vars.put(WATCH_SERVICE, true );
        }

        if ( closable ) {
            vars.put( CLOSABLE, true );
        }

        if ( maxSize > 0 ) {
            vars.put( MAX_SIZE, maxSize );
        }

        if ( !drives.isEmpty()) {
            vars.put( "drives", drives );
        }

        return Pathss.getOrCreate(
                    URI.create( "memoryntfs" + ":" + name + "!" ),
                    vars );
    }

    public MemoryNTFSBuilder watchService( boolean on ) {
        watchService = on;
        return this;
    }

    public MemoryNTFSBuilder closable( boolean on ) {
        closable = on;
        return this;
    }

    public MemoryNTFSBuilder maxSize( long max ) {
        this.maxSize = max;
        return this;
    }

    public MemoryNTFSBuilder name( String name ) {
        this.name = name;
        return this;
    }

    public MemoryNTFSBuilder drives( Character ... dr ) {
        this.drives.addAll( Arrays.asList( dr ));
        return this;
    }
}
