/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.memoryntfs;

import de.pfabulist.kleinod.errors.Unchecked;
import de.pfabulist.kleinod.paths.PathUtils;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class MemoryNTFSBuilder {
    private boolean closable = true;
    private boolean watchService = true;
    private long maxSize;
    private String name;
    private List<Character> drives = new ArrayList<Character>();

    public static MemoryNTFSBuilder memoryNTFS() {
        return new MemoryNTFSBuilder();
    }

    public FileSystem build() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        if (this.watchService) {
            vars.put("watchService", true);
        }
        if (this.closable) {
            vars.put("closable", true);
        }
        if (this.maxSize > 0L) {
            vars.put("maxSize", this.maxSize);
        }
        if (!this.drives.isEmpty()) {
            vars.put("drives", this.drives);
        }
        try {
            return PathUtils.getOrCreate((URI)URI.create("memoryntfs:" + this.name + "!"), vars);
        }
        catch (IOException e) {
            throw Unchecked.runtime((Exception)e);
        }
    }

    public MemoryNTFSBuilder watchService(boolean on) {
        this.watchService = on;
        return this;
    }

    public MemoryNTFSBuilder closable(boolean on) {
        this.closable = on;
        return this;
    }

    public MemoryNTFSBuilder maxSize(long max) {
        this.maxSize = max;
        return this;
    }

    public MemoryNTFSBuilder name(String name) {
        this.name = name;
        return this;
    }

    public MemoryNTFSBuilder drives(Character ... dr) {
        this.drives.addAll(Arrays.asList(dr));
        return this;
    }
}

