/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.memoryntfs;

import de.pfabulist.kleinod.collection.P;
import de.pfabulist.kleinod.errors.Unchecked;
import de.pfabulist.kleinod.paths.Filess;
import de.pfabulist.lindwurm.eighty.EightyFS;
import de.pfabulist.lindwurm.eighty.EightySymLink;
import de.pfabulist.lindwurm.eighty.EightyUtils;
import de.pfabulist.lindwurm.eighty.attributes.AttributesBuilder;
import de.pfabulist.lindwurm.eighty.close.CloseableSeekableByteChannel;
import de.pfabulist.lindwurm.eighty.path.EightyPath;
import de.pfabulist.lindwurm.eighty.path.EightyPathConstraints;
import de.pfabulist.lindwurm.eighty.path.WindowsPathConstraints;
import de.pfabulist.lindwurm.eighty.watch.EightyWatcher;
import de.pfabulist.lindwurm.memory.MemoryFSBuilder;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class MemoryNTFS
implements EightyFS {
    private final String name;
    private List<String> roots = new ArrayList<String>();
    private Map<String, FileSystem> drives = new HashMap<String, FileSystem>();
    private EightyPathConstraints wpc = new WindowsPathConstraints();

    public static EightyFS create(Object name, AttributesBuilder ab, Map<String, ?> env) {
        List drives = Collections.emptyList();
        if (env.containsKey("drives")) {
            drives = (List)env.get("drives");
        }
        return new MemoryNTFS((String)name, drives);
    }

    public MemoryNTFS(String name, List<Character> drives) {
        this.roots.add("C:");
        this.drives.put("C:", MemoryFSBuilder.memoryFS().name("C").build());
        for (Character chr : drives) {
            char ch = chr.toString().toUpperCase().toCharArray()[0];
            if (ch < 'A' || ch > 'Z') {
                throw new InvalidPathException(chr.toString(), "not a drive character");
            }
            if (ch == 'C') continue;
            this.roots.add("" + ch + ":");
            this.drives.put("" + ch + ":", MemoryFSBuilder.memoryFS().name("" + ch).build());
        }
        this.name = name;
    }

    public boolean nameEquals(String a, String b) {
        return this.wpc.nameEquals(a, b);
    }

    public int nameHash(String a) {
        return this.wpc.nameHash(a);
    }

    public CloseableSeekableByteChannel newByteChannel(EightyPath path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) {
        EightyPath host = this.getHostPath(path);
        return EightyUtils.get80((FileSystem)host.getFileSystem()).newByteChannel(host, options, (FileAttribute[])attrs);
    }

    public String getSeparators() {
        return this.wpc.getSeparators();
    }

    public void createDirectory(EightyPath dir, FileAttribute<?> ... attrs) {
        EightyPath host = this.getHostPath(dir);
        EightyUtils.get80((FileSystem)host.getFileSystem()).createDirectory(host, (FileAttribute[])attrs);
    }

    public void checkAccess(EightyPath path, AccessMode ... modes) {
        try {
            EightyPath host = this.getHostPath(path);
            EightyUtils.get80((FileSystem)host.getFileSystem()).checkAccess(host, modes);
        }
        catch (RuntimeException e) {
            throw Unchecked.runtime((Exception)new NoSuchFileException("files does not exist " + path));
        }
    }

    public Stream<Path> newDirectoryStream(EightyPath dir) {
        EightyPath host = this.getHostPath(dir);
        Stream hostStream = EightyUtils.get80((FileSystem)host.getFileSystem()).newDirectoryStream(host);
        return hostStream.map(hostKid -> this.getGuestPath((Path)dir, (Path)hostKid));
    }

    public void move(EightyPath source, EightyPath target, CopyOption ... options) {
        Filess.move((Path)this.getHostPath(source), (Path)this.getHostPath(target), (CopyOption[])new CopyOption[0]);
    }

    public void delete(EightyPath path) {
        Filess.delete((Path)this.getHostPath(path));
    }

    public FileStore getFileStore(EightyPath path) {
        return Filess.getFileStore((Path)this.getHostPath(path));
    }

    public Iterable<FileStore> getFileStores() {
        ArrayList<FileStore> stores = new ArrayList<FileStore>();
        for (String key : this.drives.keySet()) {
            stores.add(this.drives.get(key).getFileStores().iterator().next());
        }
        return stores;
    }

    public <V extends FileAttributeView> V getFileAttributeView(EightyPath path, Class<V> type, LinkOption ... options) {
        EightyPath host = this.getHostPath(path);
        return (V)EightyUtils.get80((FileSystem)host.getFileSystem()).getFileAttributeView(host, type, options);
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isHidden(EightyPath path) {
        EightyPath host = this.getHostPath(path);
        return EightyUtils.get80((FileSystem)host.getFileSystem()).isHidden(host);
    }

    public boolean isClosable() {
        return false;
    }

    public boolean watchable() {
        return false;
    }

    public boolean isReopenable() {
        return false;
    }

    public void reopen() {
    }

    public void setWatcher(EightyWatcher eightyFileSystem) {
    }

    public P<Optional<String>, String> parseRootComponent(String str) {
        return this.wpc.parseRootComponent(str);
    }

    public Optional<Character> findIllegalChars(String fileName) {
        for (int i = 0; i < fileName.length(); ++i) {
            char ch = fileName.charAt(i);
            switch (ch) {
                case '\"': 
                case '*': 
                case ':': 
                case '<': 
                case '>': 
                case '?': 
                case '|': {
                    return Optional.of(Character.valueOf(ch));
                }
            }
        }
        return Optional.empty();
    }

    public Optional<String> allowAccess(Path path) {
        return this.wpc.allowAccess(path);
    }

    public List<String> getRoots() {
        return this.roots;
    }

    public void createHardLink(EightyPath normLink, EightyPath normExisting) {
        EightyPath hostLink = this.getHostPath(normLink);
        EightyUtils.get80((FileSystem)hostLink.getFileSystem()).createHardLink(hostLink, this.getHostPath(normExisting));
    }

    public void createSymLink(EightyPath link, Path existing, FileAttribute<?>[] attrs) {
        EightyPath hostLink = this.getHostPath(link);
        if (existing instanceof EightyPath) {
            try {
                EightyPath target = this.getHostPath((EightyPath)existing);
                EightyUtils.get80((FileSystem)hostLink.getFileSystem()).createSymLink(hostLink, (Path)target, (FileAttribute[])attrs);
                return;
            }
            catch (RuntimeException exp) {
                // empty catch block
            }
        }
        EightyUtils.get80((FileSystem)hostLink.getFileSystem()).createSymLink(hostLink, existing, (FileAttribute[])attrs);
    }

    public Optional<EightySymLink> getSymlink(final EightyPath path) {
        EightyPath hostLink = this.getHostPath(path);
        Optional hostSym = EightyUtils.get80((Path)hostLink).getSymlink(hostLink);
        if (!hostSym.isPresent()) {
            return Optional.empty();
        }
        final Path guestTarget = this.getGuestPath((FileSystem)path.getFileSystem(), ((EightySymLink)hostSym.get()).getTarget());
        return Optional.of(new EightySymLink(){

            public Path getTarget() {
                return guestTarget;
            }

            public EightyPath getHost() {
                return path;
            }
        });
    }

    private Path getGuestPath(FileSystem fs, Path host) {
        for (String drive : this.drives.keySet()) {
            if (!this.drives.get(drive).equals(host.getFileSystem())) continue;
            return fs.getPath(drive + host.toString(), new String[0]);
        }
        return host;
    }

    private EightyPath getHostPath(EightyPath path) {
        String root = path.getRootComponent().orElse("C:").toUpperCase();
        if (root.startsWith("\\\\")) {
            String[] els = root.split("\\\\");
            String name = els[3];
            if (name.length() != 2 || name.charAt(1) != '$') {
                throw Unchecked.runtime((Exception)new NoSuchFileException("remote unc share not supported yet " + root));
            }
            char d = name.charAt(0);
            if (d < 'A' || 'Z' < d) {
                throw Unchecked.runtime((Exception)new NoSuchFileException("unc share not supported yet " + root));
            }
            root = "" + d + ":";
        }
        if (!this.drives.containsKey(root)) {
            throw Unchecked.runtime((Exception)new NoSuchFileException("not a valid drive " + root));
        }
        EightyPath ret = (EightyPath)this.drives.get(root).getPath("/", new String[0]);
        EightyFS hostEighty = EightyUtils.get80((Path)ret);
        for (Path elem : path) {
            String elemStr = elem.toString();
            if (Files.exists((Path)ret, new LinkOption[0])) {
                ret = (EightyPath)hostEighty.newDirectoryStream(ret).filter(kid -> this.nameEquals(elemStr, kid.getFileName().toString())).findFirst().orElse(ret.resolve(elemStr));
                continue;
            }
            ret = (EightyPath)ret.resolve(elemStr);
        }
        return ret;
    }

    private Path getGuestPath(Path guest, Path hostKid) {
        Path ret = guest.getRoot();
        for (Path el : hostKid) {
            ret = ret.resolve(el.toString());
        }
        return ret;
    }
}

