/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.eighty.path;

import de.pfabulist.lindwurm.eighty.path.URIMapper;
import java.net.URI;
import java.util.Map;

public class NameURIMapper
implements URIMapper {
    private final String scheme;

    public NameURIMapper(String scheme) {
        this.scheme = scheme;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public String getSchemeSpecificPart(URI uri) {
        String s = uri.getSchemeSpecificPart();
        int pos = s.indexOf("/");
        String name = s;
        if (pos >= 0) {
            name = s.substring(0, pos);
        }
        return name;
    }

    @Override
    public String getPathPart(URI uri) {
        String s = uri.getSchemeSpecificPart();
        int pos = s.indexOf("/");
        if (pos < 0) {
            throw new IllegalArgumentException("no path part: " + uri);
        }
        return s.substring(pos, s.length());
    }

    @Override
    public String toString(Object id) {
        return (String)id;
    }

    @Override
    public String fromString(String str, Map<String, Object> env) {
        return str;
    }

    @Override
    public URI toURI(String id) {
        return URI.create(this.scheme + ":" + id);
    }
}

