/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.eighty.path;

import de.pfabulist.kleinod.emergent.Todo;
import de.pfabulist.kleinod.paths.Relativize;
import de.pfabulist.lindwurm.eighty.EightyFS;
import de.pfabulist.lindwurm.eighty.EightyFileSystem;
import de.pfabulist.lindwurm.eighty.path.GetPathConverter;
import de.pfabulist.lindwurm.eighty.watch.AttachedWatchService;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class EightyPath
implements Path {
    private final EightyFileSystem fileSystem;
    private final List<String> elems;
    private final Optional<String> rootComponent;
    private final boolean absolute;

    public EightyPath(EightyFileSystem fileSystem, String first, String ... more) {
        this(fileSystem, new GetPathConverter(fileSystem.get80(), first, more));
    }

    protected EightyPath(EightyFileSystem eightyFileSystem, GetPathConverter gp) {
        this(eightyFileSystem, gp.getRootComponent(), gp.isAbsolute(), gp.getAll());
    }

    protected EightyPath(EightyFileSystem fileSystem, Optional<String> rootStr, boolean absolute, List<String> elems) {
        this.fileSystem = fileSystem;
        this.elems = elems;
        this.rootComponent = rootStr;
        this.absolute = absolute;
        if (elems.size() > 1 && elems.contains("")) {
            throw new IllegalStateException("empty path segment");
        }
        if (this.toString().contains("//")) {
            Todo.todo();
        }
    }

    @Override
    public EightyFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public boolean isAbsolute() {
        return this.absolute;
    }

    @Override
    public Path getRoot() {
        if (this.absolute) {
            return new EightyPath(this.fileSystem, this.rootComponent, true, Collections.emptyList());
        }
        return null;
    }

    @Override
    public Path getFileName() {
        if (this.elems.isEmpty() && this.isAbsolute()) {
            return null;
        }
        if (this.elems.size() <= 1) {
            if (this.isAbsolute()) {
                return new EightyPath(this.fileSystem, Optional.empty(), false, this.elems);
            }
            return this;
        }
        return new EightyPath(this.fileSystem, Optional.empty(), false, this.elems.subList(this.elems.size() - 1, this.elems.size()));
    }

    @Override
    public EightyPath getParent() {
        if (this.equals(this.getRoot())) {
            return null;
        }
        if (!this.isAbsolute() && this.elems.size() <= 1) {
            return null;
        }
        return new EightyPath(this.fileSystem, this.rootComponent, this.absolute, this.elems.subList(0, this.elems.size() - 1));
    }

    @Override
    public int getNameCount() {
        return this.elems.size();
    }

    @Override
    public Path getName(int index) {
        if (index < 0 || index >= this.elems.size()) {
            throw new IllegalArgumentException("index " + index + " <0 or >=  " + this.getNameCount());
        }
        return new EightyPath(this.fileSystem, Optional.empty(), false, Collections.singletonList(this.elems.get(index)));
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        if (beginIndex < 0 || beginIndex >= this.elems.size() || beginIndex >= endIndex || endIndex > this.elems.size()) {
            throw new IllegalArgumentException("begin or end are not a legal interval [" + beginIndex + ", " + endIndex + ")");
        }
        Path ret = new EightyPath(this.fileSystem, this.elems.get(beginIndex), new String[0]);
        for (int i = beginIndex + 1; i < endIndex; ++i) {
            ret = ret.resolve(this.elems.get(i));
        }
        return ret;
    }

    @Override
    public boolean startsWith(Path other) {
        if (this.isAbsolute() != other.isAbsolute()) {
            return false;
        }
        for (int i = 0; i < other.getNameCount(); ++i) {
            if (i >= this.getNameCount()) {
                return false;
            }
            if (this.getName(i).equals(other.getName(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean startsWith(String other) {
        return this.startsWith(this.getFileSystem().getPath(other, new String[0]));
    }

    @Override
    public boolean endsWith(Path other) {
        for (int i = 0; i < other.getNameCount(); ++i) {
            if (i >= this.getNameCount()) {
                return false;
            }
            if (this.getName(this.getNameCount() - 1 - i).equals(other.getName(other.getNameCount() - 1 - i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean endsWith(String other) {
        return this.endsWith(this.getFileSystem().getPath(other, new String[0]));
    }

    @Override
    public EightyPath normalize() {
        ArrayList<String> newEls = new ArrayList<String>();
        Iterator<String> iterator = this.elems.iterator();
        block10: while (iterator.hasNext()) {
            String elem;
            switch (elem = iterator.next()) {
                case "..": {
                    if (newEls.size() > 0 && !((String)newEls.get(newEls.size() - 1)).equals("..")) {
                        newEls.remove(newEls.size() - 1);
                        continue block10;
                    }
                    if (this.absolute) continue block10;
                    newEls.add("..");
                    continue block10;
                }
                case ".": {
                    continue block10;
                }
                case "": {
                    continue block10;
                }
            }
            newEls.add(elem);
        }
        if (!this.absolute && newEls.isEmpty()) {
            return new EightyPath(this.fileSystem, this.rootComponent, false, Collections.singletonList(""));
        }
        return new EightyPath(this.fileSystem, this.rootComponent, this.absolute, newEls);
    }

    @Override
    public Path resolve(Path other) {
        if (!this.fileSystem.provider().equals(other.getFileSystem().provider())) {
            throw new ProviderMismatchException();
        }
        if (other.isAbsolute()) {
            return other;
        }
        if (!(other.getFileSystem() instanceof EightyFileSystem)) {
            throw new ProviderMismatchException("Argument is from an other provider " + other);
        }
        EightyPath rother = (EightyPath)other;
        if (rother.rootComponent.isPresent() && !this.rootComponent.equals(rother.rootComponent)) {
            return other;
        }
        if (rother.elems.size() == 1 && rother.elems.get(0).isEmpty()) {
            return this;
        }
        if (this.elems.size() == 1 && this.elems.get(0).isEmpty()) {
            return other;
        }
        ArrayList<String> newEls = new ArrayList<String>();
        newEls.addAll(this.elems);
        newEls.addAll(((EightyPath)other).elems);
        EightyPath ret = new EightyPath(this.fileSystem, this.rootComponent, this.absolute, newEls);
        return ret;
    }

    @Override
    public Path resolve(String other) {
        return this.resolve(new EightyPath(this.fileSystem, other, new String[0]));
    }

    @Override
    public Path resolveSibling(Path other) {
        if (other.isAbsolute()) {
            return other;
        }
        EightyPath parent = this.getParent();
        if (parent == null) {
            return other;
        }
        return this.getParent().resolve(other);
    }

    @Override
    public Path resolveSibling(String other) {
        return this.resolveSibling(new EightyPath(this.fileSystem, other, new String[0]));
    }

    @Override
    public Path relativize(Path other) {
        if (this.isAbsolute() != other.isAbsolute()) {
            throw new IllegalArgumentException("'other' is different type of Path");
        }
        return new EightyPath(this.fileSystem, Optional.empty(), false, Relativize.relativize(this.elems, ((EightyPath)other).elems));
    }

    @Override
    public URI toUri() {
        return URI.create(this.fileSystem.provider().getUriMapper().toURI(this.fileSystem.getId()).toString() + this.toUriStyle());
    }

    private String toUriStyle() {
        String ret = this.toAbsolutePath().toString();
        ret = ret.replace('\\', '/');
        ret = ret.replace(" ", "%20");
        return ret;
    }

    @Override
    public EightyPath toAbsolutePath() {
        if (this.absolute) {
            return this;
        }
        Optional<String> rc = Optional.ofNullable(this.rootComponent.orElseGet(() -> this.fileSystem.get80().getRoots().stream().reduce(null, (o, n) -> n)));
        return new EightyPath(this.fileSystem, rc, true, this.elems.size() == 1 && this.elems.get(0).isEmpty() ? Collections.emptyList() : this.elems);
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        EightyPath real = this.fileSystem.provider().toRealPathEx(this, options);
        if (!Files.exists(real, new LinkOption[0])) {
            throw new NoSuchFileException("File " + this + " does not exist");
        }
        return real;
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException("only the default fs implements toFile");
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        Todo.todo();
        return null;
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        if (!(watcher instanceof AttachedWatchService)) {
            throw new ProviderMismatchException();
        }
        AttachedWatchService attachedWatcher = (AttachedWatchService)watcher;
        if (!this.fileSystem.get80().equals(attachedWatcher.getFileSystem())) {
            throw new IllegalArgumentException();
        }
        if (!attachedWatcher.isOpen()) {
            throw new ClosedWatchServiceException();
        }
        return attachedWatcher.register(this, events);
    }

    @Override
    public Iterator<Path> iterator() {
        return new Iterator<Path>(){
            private int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < EightyPath.this.elems.size();
            }

            @Override
            public Path next() {
                EightyPath ret = new EightyPath(EightyPath.this.fileSystem, (String)EightyPath.this.elems.get(this.idx), new String[0]);
                ++this.idx;
                return ret;
            }

            @Override
            public void remove() {
                Todo.todo();
            }
        };
    }

    @Override
    public int compareTo(Path other) {
        if (!this.fileSystem.provider().equals(other.getFileSystem().provider())) {
            throw new ClassCastException("wrong provider, expected " + this.fileSystem.provider() + " got " + other.getFileSystem().provider());
        }
        return this.toString().compareTo(other.toString());
    }

    @Override
    public String toString() {
        return this.rootComponent.orElse("") + (this.absolute ? this.fileSystem.getSeparator() : "") + this.elems.stream().reduce((a, b) -> a + this.fileSystem.getSeparator() + b).orElse("");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EightyPath other = (EightyPath)o;
        if (!this.rootComponent.equals(other.rootComponent)) {
            return false;
        }
        if (!this.fileSystem.equals(other.fileSystem)) {
            return false;
        }
        if (this.elems.size() != other.elems.size()) {
            return false;
        }
        for (int i = 0; i < this.elems.size(); ++i) {
            if (this.fileSystem.get80().nameEquals(this.elems.get(i), other.elems.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        EightyFS ec = this.fileSystem.get80();
        int result = this.fileSystem.hashCode();
        result = this.elems.stream().map(ec::nameHash).reduce(result, (sofar, now) -> 31 * sofar + now);
        result = 31 * result + this.rootComponent.hashCode();
        return result;
    }

    public Optional<String> getRootComponent() {
        return this.rootComponent;
    }
}

