/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.eighty.attributes;

import de.pfabulist.lindwurm.eighty.attributes.GuestFileAttributes;
import de.pfabulist.lindwurm.eighty.attributes.LinkInfoSettable;
import de.pfabulist.lindwurm.eighty.attributes.ReadonlySettable;
import java.io.IOException;
import java.nio.file.ReadOnlyFileSystemException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileTime;

public class GuestFileAttributeView
implements BasicFileAttributeView,
LinkInfoSettable,
ReadonlySettable {
    private final BasicFileAttributeView host;
    private boolean sym;
    private boolean readonly;

    public GuestFileAttributeView(BasicFileAttributeView host, boolean sym) {
        this.host = host;
        this.sym = sym;
    }

    @Override
    public String name() {
        return this.host.name();
    }

    @Override
    public GuestFileAttributes readAttributes() throws IOException {
        return new GuestFileAttributes(this.host.readAttributes(), this.sym);
    }

    @Override
    public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
        if (this.readonly) {
            throw new ReadOnlyFileSystemException();
        }
        this.host.setTimes(lastModifiedTime, lastAccessTime, createTime);
    }

    @Override
    public void setLink() {
        this.sym = true;
    }

    @Override
    public void setReadonly() {
        this.readonly = true;
    }
}

