/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.eighty.attributes;

import de.pfabulist.lindwurm.eighty.attributes.AttributeConnection;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttributeView;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class AttributesProvider {
    private Map<String, AttributeConnection> nameToConnection = new HashMap<String, AttributeConnection>();
    private Map<Class, Class> readToView = new HashMap<Class, Class>();
    private Map<Class, Class> viewToRead = new HashMap<Class, Class>();

    public <V extends FileAttributeView> boolean supportsView(Class<V> type) {
        return this.viewToRead.containsKey(type);
    }

    public <A extends BasicFileAttributeView> Optional<Class<A>> getViewfromRead(Class<? extends BasicFileAttributes> type) {
        return Optional.ofNullable(this.readToView.get(type));
    }

    public Optional<AttributeConnection> getConnectionFromName(String viewName) {
        return Optional.ofNullable(this.nameToConnection.get(viewName));
    }

    public AttributesProvider(List<AttributeConnection> connections) {
        for (AttributeConnection ac : connections) {
            this.nameToConnection.put(ac.getName(), ac);
            this.readToView.put(ac.getReadType(), ac.getViewType());
            this.viewToRead.put(ac.getViewType(), ac.getReadType());
        }
    }

    public Set<String> supportedFileAttributeViewNames() {
        return this.nameToConnection.keySet();
    }
}

