/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.eighty.attributes;

import de.pfabulist.unchecked.Unchecked;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class AttributeConnection<V extends BasicFileAttributeView, R extends BasicFileAttributes> {
    private final String name;
    private final Class<V> viewType;
    private final Class<R> readType;
    Map<String, Function<R, Object>> read = new HashMap<String, Function<R, Object>>();
    Map<String, BiConsumer<V, Object>> view = new HashMap<String, BiConsumer<V, Object>>();

    public AttributeConnection(String name, Class<V> bfav, Class<R> bfas) {
        this.name = name;
        this.viewType = bfav;
        this.readType = bfas;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getAttributeNames() {
        return this.read.keySet();
    }

    public Class<V> getViewType() {
        return this.viewType;
    }

    public Class<R> getReadType() {
        return this.readType;
    }

    public Object get(R bfas, String attiName) {
        if (!this.read.containsKey(attiName)) {
            throw new IllegalArgumentException("no such atti " + attiName);
        }
        return this.read.get(attiName).apply(bfas);
    }

    public void set(V bfav, String attiName, Object value) {
        if (!this.view.containsKey(attiName)) {
            throw new IllegalArgumentException("no such atti " + attiName);
        }
        try {
            this.view.get(attiName).accept(bfav, value);
        }
        catch (Exception e) {
            throw Unchecked.u((Throwable)e);
        }
    }
}

