/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.eighty;

import de.pfabulist.lindwurm.eighty.close.CloseableSeekableByteChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;

public class GuestChannel
implements CloseableSeekableByteChannel {
    final SeekableByteChannel host;
    private boolean open = true;
    private final Runnable onClose;

    public GuestChannel(SeekableByteChannel host, Runnable onClose) {
        this.host = host;
        this.onClose = onClose;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        return this.host.read(dst);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        return this.host.write(src);
    }

    @Override
    public long position() throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        return this.host.position();
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        return this.host.position(newPosition);
    }

    @Override
    public long size() throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        return this.host.size();
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        return this.host.truncate(size);
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        this.host.close();
        if (this.open) {
            this.onClose.run();
        }
        this.open = false;
    }
}

