/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.eighty;

import de.pfabulist.lindwurm.eighty.EightyFS;
import de.pfabulist.lindwurm.eighty.EightyFileSystem;
import de.pfabulist.lindwurm.eighty.path.EightyPath;
import de.pfabulist.unchecked.Unchecked;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class EightyUtils {
    public static EightyFS get80(FileSystem fs) {
        if (fs instanceof EightyFileSystem) {
            return ((EightyFileSystem)fs).get80();
        }
        throw new IllegalArgumentException("this is not an EightyFileSystem " + fs);
    }

    public static EightyFS get80(Path path) {
        return EightyUtils.get80(path.getFileSystem());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Stream<Path> getDirectoryStream(Path host) {
        if (host.getFileSystem() instanceof EightyFileSystem) {
            return EightyUtils.get80(host.getFileSystem()).newDirectoryStream((EightyPath)host);
        }
        try (DirectoryStream<Path> dstr = Files.newDirectoryStream(host);){
            ArrayList<Path> ret = new ArrayList<Path>();
            for (Path kid : dstr) {
                ret.add(kid);
            }
            Stream stream = StreamSupport.stream(ret.spliterator(), false);
            return stream;
        }
        catch (IOException e) {
            throw Unchecked.u((Throwable)e);
        }
    }

    public static Optional<String> checkFilenameLength(Path path, int maxFilenameLength) {
        for (Path el : path) {
            if (el.toString().length() <= maxFilenameLength) continue;
            return Optional.of("path element too long, max length" + maxFilenameLength + " got " + el);
        }
        return Optional.empty();
    }
}

