/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.eighty.watch;

import de.pfabulist.lindwurm.eighty.EightyFS;
import de.pfabulist.lindwurm.eighty.close.InformativeClosable;
import de.pfabulist.lindwurm.eighty.path.EightyPath;
import de.pfabulist.lindwurm.eighty.watch.AttachedWatchService;
import de.pfabulist.lindwurm.eighty.watch.EightyWatchKey;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

public class EightyWatchService
implements AttachedWatchService,
InformativeClosable {
    private Set<EightyWatchKey> keyPool = Collections.newSetFromMap(new ConcurrentHashMap());
    private BlockingDeque<WatchKey> que = new LinkedBlockingDeque<WatchKey>();
    private final EightyFS memoryFS;
    private Set<Thread> waiting = Collections.newSetFromMap(new ConcurrentHashMap());
    private boolean open = true;

    public EightyWatchService(EightyFS memoryFS) {
        this.memoryFS = memoryFS;
    }

    @Override
    public void close() throws IOException {
        this.open = false;
        for (Thread thread : this.waiting) {
            thread.interrupt();
        }
        this.waiting.clear();
        for (EightyWatchKey key : this.keyPool) {
            key.cancel();
        }
        this.keyPool.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WatchKey poll() {
        BlockingDeque<WatchKey> blockingDeque = this.que;
        synchronized (blockingDeque) {
            if (this.que.isEmpty()) {
                return null;
            }
            return (WatchKey)this.que.removeLast();
        }
    }

    @Override
    public WatchKey poll(long timeout, TimeUnit unit) throws InterruptedException {
        try {
            Thread current = Thread.currentThread();
            this.waiting.add(current);
            WatchKey ret = this.que.pollLast(timeout, unit);
            this.waiting.remove(current);
            return ret;
        }
        catch (InterruptedException ex) {
            throw new ClosedWatchServiceException();
        }
    }

    @Override
    public WatchKey take() throws InterruptedException {
        try {
            Thread current = Thread.currentThread();
            this.waiting.add(current);
            WatchKey ret = this.que.takeLast();
            this.waiting.remove(current);
            return ret;
        }
        catch (InterruptedException ex) {
            throw new ClosedWatchServiceException();
        }
    }

    @Override
    public EightyFS getFileSystem() {
        return this.memoryFS;
    }

    @Override
    public WatchKey register(EightyPath path, WatchEvent.Kind<?> ... events) {
        EightyWatchKey key = new EightyWatchKey(path, events);
        this.keyPool.add(key);
        return key;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signal(EightyPath path, WatchEvent.Kind<Path> event) {
        for (EightyWatchKey key : this.keyPool) {
            if (!key.isWatchingFor(path.getParent(), event)) continue;
            EightyWatchKey eightyWatchKey = key;
            synchronized (eightyWatchKey) {
                if (key.isReady()) {
                    this.que.addFirst(key);
                }
                key.signal(event, path);
            }
        }
    }
}

