/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.eighty.watch;

import de.pfabulist.lindwurm.eighty.path.EightyPath;
import de.pfabulist.lindwurm.eighty.watch.EightyWatchEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.Watchable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EightyWatchKey
implements WatchKey {
    private final EightyPath watchable;
    private final List<WatchEvent.Kind<?>> watching;
    private List<WatchEvent<?>> happened = new ArrayList();
    private boolean ready = true;
    private boolean valid = true;

    public EightyWatchKey(EightyPath path, WatchEvent.Kind<?> ... events) {
        this.watchable = path;
        this.watching = Arrays.asList(events);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid() {
        EightyWatchKey eightyWatchKey = this;
        synchronized (eightyWatchKey) {
            if (!Files.exists(this.watchable, new LinkOption[0])) {
                this.valid = false;
            }
            return this.valid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WatchEvent<?>> pollEvents() {
        ArrayList ret = new ArrayList();
        List<WatchEvent<?>> list = this.happened;
        synchronized (list) {
            ret.addAll(this.happened);
            this.happened.clear();
        }
        return ret;
    }

    @Override
    public boolean reset() {
        if (this.happened.isEmpty()) {
            this.ready = true;
        }
        return this.valid;
    }

    @Override
    public void cancel() {
        this.valid = false;
    }

    @Override
    public Watchable watchable() {
        return this.watchable;
    }

    public boolean isWatchingFor(EightyPath path, WatchEvent.Kind<Path> event) {
        return this.valid && this.watchable.equals(path) && this.watching.contains(event);
    }

    public void signal(WatchEvent.Kind<Path> event, Path path) {
        this.happened.add(new EightyWatchEvent<Path>(this.watchable.relativize(path), event));
        this.ready = false;
    }

    public boolean isReady() {
        return this.ready;
    }
}

