/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.eighty.path;

import de.pfabulist.kleinod.collection.P;
import de.pfabulist.lindwurm.eighty.EightyUtils;
import de.pfabulist.lindwurm.eighty.path.EightyPathConstraints;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class WindowsPathConstraints
implements EightyPathConstraints {
    @Override
    public boolean nameEquals(String a, String b) {
        return a.equalsIgnoreCase(b);
    }

    @Override
    public int nameHash(String a) {
        return a.toUpperCase().hashCode();
    }

    @Override
    public String getSeparators() {
        return "\\/";
    }

    @Override
    public P<Optional<String>, String> parseRootComponent(String str) {
        if (str.startsWith("\\\\") || str.startsWith("//") || str.startsWith("\\/") || str.startsWith("/\\")) {
            String[] elms = str.split("\\\\|/");
            List elems = Arrays.asList(elms).stream().filter(x -> !x.isEmpty()).collect(Collectors.toList());
            if (elems.size() < 2) {
                throw new InvalidPathException(str, "not a valid unc path ");
            }
            String norm = elems.stream().reduce("\\", (before, elem) -> before + "\\" + elem);
            if (elems.size() == 2) {
                norm = norm + "\\";
            }
            int rootCompoLength = 3 + ((String)elems.get(0)).length() + ((String)elems.get(1)).length();
            return P.of(Optional.of(norm.substring(0, rootCompoLength)), (Object)norm.substring(rootCompoLength));
        }
        if (str.length() < 2 || str.charAt(1) != ':') {
            return P.of(Optional.empty(), (Object)str);
        }
        char ch = str.toUpperCase().charAt(0);
        if (ch >= 'A' && ch <= 'Z') {
            return P.of(Optional.of("" + ch + ":"), (Object)str.substring(2));
        }
        return P.of(Optional.empty(), (Object)str);
    }

    @Override
    public Optional<String> allowAccess(Path path) {
        Optional<String> message = EightyUtils.checkFilenameLength(path, 255);
        if (message.isPresent()) {
            return message;
        }
        for (Path filename : path) {
            if (!filename.toString().equalsIgnoreCase("nul")) continue;
            return Optional.of("illegal filename: nul");
        }
        return Optional.empty();
    }
}

