/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.eighty.path;

import de.pfabulist.kleinod.collection.P;
import de.pfabulist.lindwurm.eighty.path.EightyPathConstraints;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class GetPathConverter {
    private final EightyPathConstraints ec;
    private final Optional<String> rootComponent;
    private boolean absolute;
    private List<String> elems = new ArrayList<String>();

    public GetPathConverter(EightyPathConstraints ec, String first, String ... more) {
        this.ec = ec;
        P<Optional<String>, String> p = ec.parseRootComponent(first);
        this.rootComponent = (Optional)p.i0;
        first = (String)p.i1;
        this.absolute = !first.isEmpty() && ec.getSeparators().contains(first.substring(0, 1));
        this.add(this.elems, first);
        for (String elem : more) {
            this.add(this.elems, elem);
        }
    }

    private void add(List<String> elems, String one) {
        for (String sub : one.split(GetPathConverter.deregex(this.ec.getSeparators()))) {
            this.ec.findIllegalChars(sub).ifPresent(ch -> {
                throw new InvalidPathException(sub, "contains illegal char <" + ch + ">");
            });
            if (sub.isEmpty()) continue;
            elems.add(sub);
        }
    }

    public static String deregex(String sep) {
        String ret = "";
        for (int i = 0; i < sep.length(); ++i) {
            ret = sep.charAt(i) == '\\' ? ret + "\\\\|" : ret + sep.charAt(i) + "|";
        }
        return ret.substring(0, ret.length() - 1);
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public String getFirst() {
        if (this.elems.isEmpty()) {
            return "";
        }
        return this.elems.get(0);
    }

    public String[] getMore() {
        if (this.elems.isEmpty()) {
            return new String[0];
        }
        return this.elems.subList(1, this.elems.size()).toArray(new String[0]);
    }

    public List<String> getAll() {
        if (this.elems.isEmpty() && !this.absolute) {
            return Collections.singletonList("");
        }
        return this.elems;
    }

    public Optional<String> getRootComponent() {
        return this.rootComponent;
    }
}

