/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.eighty;

import de.pfabulist.kleinod.collection.P;
import de.pfabulist.kleinod.paths.Pathss;
import de.pfabulist.lindwurm.eighty.EightyFS;
import de.pfabulist.lindwurm.eighty.EightyFileSystem;
import de.pfabulist.lindwurm.eighty.EightySymLink;
import de.pfabulist.lindwurm.eighty.EightyUtils;
import de.pfabulist.lindwurm.eighty.path.EightyPath;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class RealPath {
    private final Set<Path> before = new HashSet<Path>();
    private final Path start;
    private int loopDetector = 0;

    public RealPath(EightyPath path) {
        this.start = this.absRoot(path);
    }

    public Path to() {
        return (Path)P.until((Object)this.start, this::minusOneSymLink);
    }

    private Path absRoot(Path path) {
        Path ret = path.toAbsolutePath();
        if (!(ret.getFileSystem() instanceof EightyFileSystem)) {
            return ret;
        }
        EightyFS efs = EightyUtils.get80(ret);
        if (!efs.getRoots().isEmpty() && !((EightyPath)ret).getRootComponent().isPresent()) {
            ret = path.getFileSystem().getPath(efs.getRoots().get(0) + ret, new String[0]);
        }
        return ret;
    }

    private P<Boolean, Path> minusOneSymLink(Path path) {
        if (this.loopDetector > 100000) {
            throw new IllegalStateException("sym link loop detected in path " + this.start);
        }
        ++this.loopDetector;
        Path ret = path.getRoot();
        boolean notFound = true;
        for (Path filename : path) {
            Optional<EightySymLink> sym;
            if (filename.toString().equals("..")) {
                if (Pathss.isRoot((Path)ret)) continue;
                ret = ret.getParent();
                continue;
            }
            if (filename.toString().equals("..")) continue;
            ret = ret.resolve(filename);
            if (!notFound || !(sym = EightyUtils.get80(path).getSymlink((EightyPath)ret)).isPresent()) continue;
            ret = this.absRoot(ret.getParent().resolve(sym.get().getTarget()));
            notFound = false;
        }
        return P.of((Object)notFound, (Object)ret);
    }
}

