/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.eighty;

import de.pfabulist.kleinod.errors.FunctionE;
import de.pfabulist.kleinod.errors.Unchecked;
import de.pfabulist.kleinod.paths.Pathss;
import de.pfabulist.lindwurm.eighty.EightyDirectoryStream;
import de.pfabulist.lindwurm.eighty.EightyFS;
import de.pfabulist.lindwurm.eighty.EightyFSCreator;
import de.pfabulist.lindwurm.eighty.EightyFileSystem;
import de.pfabulist.lindwurm.eighty.EightySymLink;
import de.pfabulist.lindwurm.eighty.EightyUtils;
import de.pfabulist.lindwurm.eighty.RealPath;
import de.pfabulist.lindwurm.eighty.RuntimeProxy;
import de.pfabulist.lindwurm.eighty.attributes.AttributeConnection;
import de.pfabulist.lindwurm.eighty.attributes.AttributeKeys;
import de.pfabulist.lindwurm.eighty.attributes.AttributesBuilder;
import de.pfabulist.lindwurm.eighty.attributes.LinkInfoSettable;
import de.pfabulist.lindwurm.eighty.path.EightyPath;
import de.pfabulist.lindwurm.eighty.path.URIMapper;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotLinkException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class EightyProvider
extends FileSystemProvider {
    private final ConcurrentMap<String, EightyFileSystem> fileSystems = new ConcurrentHashMap<String, EightyFileSystem>();
    private final URIMapper uriMapper;
    private final EightyFSCreator creator;

    public EightyProvider(URIMapper uriMapper, EightyFSCreator creator) {
        this.uriMapper = uriMapper;
        this.creator = creator;
    }

    @Override
    public String getScheme() {
        return this.uriMapper.getScheme();
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env2) throws IOException {
        AttributesBuilder attributesBuilder;
        this.checkURI(uri);
        Map<String, Object> env = env2;
        String id = this.uriMapper.getSchemeSpecificPart(uri);
        if (id == null) {
            throw new IllegalArgumentException("scheme specific part is null : " + uri);
        }
        if (this.fileSystems.containsKey(id) && ((EightyFileSystem)this.fileSystems.get(id)).isOpen()) {
            throw new FileSystemAlreadyExistsException(id);
        }
        Object fsid = this.uriMapper.fromString(id, env);
        EightyFS efs = this.creator.create(fsid, attributesBuilder = AttributesBuilder.attributes(), env);
        if (efs == null) {
            return null;
        }
        EightyFileSystem eightyFileSystem = new EightyFileSystem(efs, id, this, attributesBuilder.build());
        this.fileSystems.put(id, eightyFileSystem);
        efs.setWatcher(eightyFileSystem);
        return eightyFileSystem;
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        this.checkURI(uri);
        String id = this.uriMapper.getSchemeSpecificPart(uri);
        FileSystem ret = (FileSystem)this.fileSystems.get(id);
        if (ret == null) {
            throw new FileSystemNotFoundException(uri.toString());
        }
        if (!ret.isOpen()) {
            this.fileSystems.remove(id);
            throw new FileSystemNotFoundException(uri.toString());
        }
        return ret;
    }

    @Override
    public Path getPath(URI uri) {
        this.checkURI(uri);
        FileSystem fs = Pathss.getOrCreate((URI)uri, Collections.emptyMap());
        return fs.getPath(this.deUri(fs, this.uriMapper.getPathPart(uri)), new String[0]);
    }

    public EightyPath toRealPath(Path path) {
        if (!(path instanceof EightyPath)) {
            throw new IllegalArgumentException(path + " shouls be EightyPath");
        }
        return (EightyPath)new RealPath((EightyPath)path).to();
    }

    public EightyPath toRealPathEx(Path path, LinkOption ... options) {
        if (!(path instanceof EightyPath)) {
            throw new IllegalArgumentException(path + " shouls be EightyPath");
        }
        if (options.length == 0) {
            return this.toRealPath(path);
        }
        if (path.getParent() == null) {
            return (EightyPath)path;
        }
        EightyPath parent = this.toRealPath(path.getParent());
        return (EightyPath)parent.resolve(path.getFileName());
    }

    @Override
    public SeekableByteChannel newByteChannel(Path pathArg, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        EightyFS eightyFS = this.checkProviderAndGet80(pathArg);
        EightyFileSystem eightyFileSystem = (EightyFileSystem)pathArg.getFileSystem();
        EightyPath path = this.toRealPath(pathArg);
        this.allowAccess(path);
        HashSet<? extends OpenOption> impliedOptions = new HashSet<OpenOption>();
        impliedOptions.addAll(options);
        if (impliedOptions.isEmpty()) {
            impliedOptions.add(StandardOpenOption.READ);
        }
        if (path.getParent() != null && !Files.exists(path.getParent(), new LinkOption[0])) {
            throw new NoSuchFileException(path.getParent().toString());
        }
        if (!Files.exists(path, new LinkOption[0])) {
            if (!options.contains(StandardOpenOption.WRITE)) {
                throw new NoSuchFileException(path.toString());
            }
            if (!options.contains(StandardOpenOption.CREATE) && !options.contains(StandardOpenOption.CREATE_NEW)) {
                throw new NoSuchFileException(path.toString());
            }
        } else if (options.contains(StandardOpenOption.CREATE_NEW)) {
            throw new FileAlreadyExistsException(path.toString());
        }
        if (options.contains(StandardOpenOption.APPEND) && options.contains(StandardOpenOption.READ)) {
            throw new IllegalArgumentException("APPEND + READ not allowed");
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw new FileSystemException(path.toString() + " is a directory");
        }
        try {
            return eightyFileSystem.addClosable(eightyFS.newByteChannel(path, impliedOptions, attrs));
        }
        catch (RuntimeException e) {
            throw (IOException)Unchecked.unwrap(IOException.class, (RuntimeException)e);
        }
    }

    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return super.newFileChannel(path, options, attrs);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dirArg, DirectoryStream.Filter<? super Path> filter) throws IOException {
        this.checkProviderAndGet80(dirArg);
        EightyFileSystem fs = (EightyFileSystem)dirArg.getFileSystem();
        EightyPath dir = this.toRealPath(dirArg);
        if (!Files.exists(dir, new LinkOption[0])) {
            throw new NoSuchFileException("dir " + dir + " does not exist");
        }
        try {
            return fs.addClosable(new EightyDirectoryStream(dirArg, EightyUtils.getDirectoryStream(dir), filter));
        }
        catch (RuntimeException e) {
            throw (IOException)Unchecked.unwrap(IOException.class, (RuntimeException)e);
        }
    }

    @Override
    public void createDirectory(Path dirArg, FileAttribute<?> ... attrs) throws IOException {
        EightyFS eighty = this.checkProviderAndGet80(dirArg);
        EightyPath dir = this.toRealPathEx(dirArg, LinkOption.NOFOLLOW_LINKS);
        if (this.existsEx(dir, LinkOption.NOFOLLOW_LINKS)) {
            throw new FileAlreadyExistsException(dir.toString());
        }
        if (!Files.isDirectory(dir.getParent(), new LinkOption[0])) {
            throw new NoSuchFileException(dir.getParent().toString());
        }
        this.allowAccess(dir);
        try {
            eighty.createDirectory(dir, attrs);
        }
        catch (RuntimeException e) {
            throw (IOException)Unchecked.unwrap(IOException.class, (RuntimeException)e);
        }
    }

    @Override
    public void delete(Path pathArg) throws IOException {
        EightyFS eightyFS = this.checkProviderAndGet80(pathArg);
        EightyPath path = this.toRealPathEx(pathArg, LinkOption.NOFOLLOW_LINKS);
        Optional<EightySymLink> sym = eightyFS.getSymlink(path);
        if (!Files.exists(path, new LinkOption[0]) && !sym.isPresent()) {
            throw new NoSuchFileException("no such file" + pathArg);
        }
        if (path.getParent() == null) {
            throw new IllegalArgumentException("can't delete root");
        }
        if (sym.isPresent()) {
            eightyFS.delete(sym.get().getHost());
            return;
        }
        if (Files.isDirectory(path, new LinkOption[0]) && !Pathss.isEmpty((Path)path)) {
            throw new DirectoryNotEmptyException("dir not empty" + pathArg);
        }
        try {
            eightyFS.delete(path);
        }
        catch (RuntimeException e) {
            throw (IOException)Unchecked.unwrap(IOException.class, (RuntimeException)e);
        }
    }

    @Override
    public void copy(Path osource, Path otarget, CopyOption ... options) throws IOException {
        this.checkProviderAndGet80(otarget);
        EightyFS srcEightyFS = this.checkProviderAndGet80(osource);
        if (Files.isSameFile(osource, otarget)) {
            return;
        }
        if (!Arrays.asList(options).contains(StandardCopyOption.REPLACE_EXISTING) && this.existsEx(otarget, LinkOption.NOFOLLOW_LINKS)) {
            throw new FileAlreadyExistsException(otarget.toString());
        }
        if (Files.isDirectory(otarget, new LinkOption[0]) && !Pathss.isEmpty((Path)otarget)) {
            throw new DirectoryNotEmptyException("" + otarget + " is not empty");
        }
        if (this.existsEx(otarget, LinkOption.NOFOLLOW_LINKS)) {
            Files.delete(otarget);
        }
        EightyPath source = this.toRealPath(osource);
        EightyPath target = this.toRealPath(otarget);
        if (Files.isDirectory(source, new LinkOption[0])) {
            Files.createDirectory(target, new FileAttribute[0]);
            return;
        }
        try {
            srcEightyFS.copy(source, target, options);
        }
        catch (RuntimeException e) {
            throw (IOException)Unchecked.unwrap(IOException.class, (RuntimeException)e);
        }
        if (Arrays.asList(options).contains(StandardCopyOption.COPY_ATTRIBUTES)) {
            Files.setLastModifiedTime(target, Files.getLastModifiedTime(source, new LinkOption[0]));
        }
    }

    @Override
    public void move(Path osource, Path otarget, CopyOption ... options) throws IOException {
        EightyFS source80 = this.checkProviderAndGet80(osource);
        EightyFS target80 = this.checkProviderAndGet80(otarget);
        EightyPath target = this.toRealPathEx(otarget, LinkOption.NOFOLLOW_LINKS);
        EightyPath source = this.toRealPathEx(osource, LinkOption.NOFOLLOW_LINKS);
        if (source.getParent() == null) {
            throw new FileSystemException("root can not be moved");
        }
        if (!Arrays.asList(options).contains(StandardCopyOption.REPLACE_EXISTING) && Files.exists(target, LinkOption.NOFOLLOW_LINKS)) {
            throw new FileAlreadyExistsException(target.toString());
        }
        if (Files.isDirectory(target, new LinkOption[0]) && !Pathss.isEmpty((Path)target)) {
            throw new DirectoryNotEmptyException(target.toString());
        }
        if (!Files.exists(target.getParent(), new LinkOption[0])) {
            throw new NoSuchFileException("parent of target is missing " + otarget);
        }
        this.allowAccess(target);
        Files.deleteIfExists(target);
        for (Path parent = target.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.equals(source)) continue;
            throw new FileSystemException("a directory can not be moved into one of its own subdirectories");
        }
        if (Files.isSymbolicLink(source)) {
            Files.createSymbolicLink(target, source80.getSymlink(source).get().getTarget(), new FileAttribute[0]);
            Files.delete(source);
            return;
        }
        try {
            source80.move(source, target, options);
        }
        catch (RuntimeException e) {
            throw (IOException)Unchecked.unwrap(IOException.class, (RuntimeException)e);
        }
    }

    @Override
    public boolean isSameFile(Path opath, Path opath2) throws IOException {
        if (!opath.getFileSystem().provider().equals(opath2.getFileSystem().provider())) {
            return false;
        }
        this.checkProviderAndGet80(opath);
        if (opath.equals(opath2)) {
            return true;
        }
        if (!Files.exists(opath, new LinkOption[0]) && Files.exists(opath2, new LinkOption[0])) {
            return false;
        }
        if (!Files.exists(opath2, new LinkOption[0])) {
            if (Files.exists(opath, new LinkOption[0])) {
                return false;
            }
            EightyPath r1 = ((EightyProvider)opath.getFileSystem().provider()).toRealPathEx(opath, LinkOption.NOFOLLOW_LINKS);
            EightyPath r2 = ((EightyProvider)opath.getFileSystem().provider()).toRealPathEx(opath2, LinkOption.NOFOLLOW_LINKS);
            return r1.equals(r2);
        }
        Object fk1 = Files.readAttributes(opath, BasicFileAttributes.class, new LinkOption[0]).fileKey();
        Object fk2 = Files.readAttributes(opath2, BasicFileAttributes.class, new LinkOption[0]).fileKey();
        if (fk1 != null && fk2 != null && fk1.equals(fk2)) {
            return true;
        }
        Path r1 = opath.toRealPath(new LinkOption[0]);
        Path r2 = opath2.toRealPath(new LinkOption[0]);
        return r1.equals(r2);
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        this.checkProviderAndGet80(path);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new NoSuchFileException(path.toString());
        }
        return this.checkProviderAndGet80(path).isHidden(this.toRealPath(path));
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        this.checkProviderAndGet80(path);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new NoSuchFileException(path.toString());
        }
        return this.checkProviderAndGet80(path).getFileStore(this.toRealPath(path));
    }

    @Override
    public void checkAccess(Path pathArg, AccessMode ... modes) throws IOException {
        EightyFS efs = this.checkProviderAndGet80(pathArg);
        EightyPath path = this.toRealPath(pathArg);
        try {
            efs.checkAccess(path, modes);
        }
        catch (RuntimeException e) {
            throw (IOException)Unchecked.unwrap(IOException.class, (RuntimeException)e);
        }
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        EightyFS efs = this.checkProviderAndGet80(path);
        if (!this.existsEx(path, options)) {
            if (!((EightyFileSystem)path.getFileSystem()).getAttributeProvider().supportsView(type)) {
                return null;
            }
            return (V)((FileAttributeView)RuntimeProxy.of(type, (FunctionE<String, Object, Exception>)((FunctionE)name -> {
                if (name.equals("name")) {
                    return "FileAttributeProxy";
                }
                throw new NoSuchFileException(path.toString());
            })));
        }
        EightyPath real = this.toRealPathEx(path, options);
        if (!((EightyFileSystem)path.getFileSystem()).getAttributeProvider().supportsView(type)) {
            return null;
        }
        Optional<EightySymLink> sym = efs.getSymlink(real);
        if (sym.isPresent()) {
            V fav = efs.getFileAttributeView(sym.get().getHost(), type);
            if (!(fav instanceof LinkInfoSettable)) {
                throw new UnsupportedOperationException("the attribute view need to implement LinkInfoSettable in order to make SymLinks work");
            }
            ((LinkInfoSettable)fav).setLink();
            return fav;
        }
        return efs.getFileAttributeView(real, type);
    }

    private boolean existsEx(Path path, LinkOption ... options) {
        if (Files.exists(path, new LinkOption[0])) {
            return true;
        }
        if (options.length == 0 || !options[0].equals(LinkOption.NOFOLLOW_LINKS)) {
            return false;
        }
        try {
            Files.readSymbolicLink(path);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        this.checkProviderAndGet80(path);
        if (!this.existsEx(path, options)) {
            throw new NoSuchFileException(path + " does not exist");
        }
        Class view = ((EightyFileSystem)path.getFileSystem()).getAttributeProvider().getViewfromRead(type).orElseThrow(() -> new UnsupportedOperationException(type + " not a supported FileAttributes class"));
        return (A)((BasicFileAttributeView)this.getFileAttributeView(path, view, options)).readAttributes();
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        EightyFS efs = this.checkProviderAndGet80(path);
        if (!this.existsEx(path, options)) {
            throw new NoSuchFileException(path + " does not exist");
        }
        EightyPath real = this.toRealPathEx(path, options);
        String viewName = AttributeKeys.getName(attributes);
        AttributeConnection connection = real.getFileSystem().getAttributeProvider().getConnectionFromName(viewName).orElseThrow(() -> new UnsupportedOperationException(viewName + " is not a supported FileAttributeView"));
        BasicFileAttributeView view = (BasicFileAttributeView)this.getFileAttributeView(real, connection.getViewType(), options);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (String key : AttributeKeys.getKeys(attributes, connection.getAttributeNames())) {
            ret.put(key, connection.get(view.readAttributes(), key));
        }
        return ret;
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        EightyFS efs = this.checkProviderAndGet80(path);
        String viewName = AttributeKeys.getName(attribute);
        AttributeConnection connection = ((EightyFileSystem)path.getFileSystem()).getAttributeProvider().getConnectionFromName(viewName).orElseThrow(() -> new UnsupportedOperationException(viewName + " is not a supported FileAttributeView"));
        Set<String> keys = AttributeKeys.getKeys(attribute, connection.getAttributeNames());
        if (keys.size() != 1) {
            throw new IllegalArgumentException("you can set only one attribute at a time");
        }
        BasicFileAttributeView view = (BasicFileAttributeView)this.getFileAttributeView(path, connection.getViewType(), options);
        connection.set(view, keys.iterator().next(), value);
    }

    @Override
    public void createLink(Path link, Path existing) throws IOException {
        EightyFS efs = this.checkProviderAndGet80(existing);
        this.checkProviderAndGet80(link);
        if (this.existsEx(link, LinkOption.NOFOLLOW_LINKS)) {
            throw new FileAlreadyExistsException(link.toString());
        }
        if (!link.getFileSystem().equals(existing.getFileSystem())) {
            throw new FileSystemException("cannot link to a different filesystem");
        }
        EightyPath rLink = this.toRealPath(link);
        this.allowAccess(rLink);
        EightyPath rExisting = this.toRealPath(existing);
        try {
            efs.createHardLink(rLink, rExisting);
        }
        catch (RuntimeException e) {
            throw (IOException)Unchecked.unwrap(IOException.class, (RuntimeException)e);
        }
    }

    @Override
    public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
        EightyFS efs = this.checkProviderAndGet80(link);
        this.checkProviderAndGet80(target);
        EightyPath normLink = this.toRealPath(link);
        if (Files.exists(normLink, new LinkOption[0])) {
            throw new FileAlreadyExistsException(link.toString());
        }
        this.allowAccess(normLink);
        efs.createSymLink(normLink, (EightyPath)target, attrs);
    }

    @Override
    public Path readSymbolicLink(Path link) throws IOException {
        EightyFS efs = this.checkProviderAndGet80(link);
        EightyPath real = this.toRealPathEx(link, LinkOption.NOFOLLOW_LINKS);
        Optional<EightySymLink> sym = efs.getSymlink(real);
        if (sym.isPresent()) {
            return sym.get().getTarget();
        }
        throw new NotLinkException(link.toString());
    }

    public URIMapper getUriMapper() {
        return this.uriMapper;
    }

    private boolean isOtherFileSystem(Path nn, EightyPath old) {
        return !nn.getFileSystem().equals(old.getFileSystem());
    }

    private void allowAccess(EightyPath path) throws FileSystemException {
        Optional<String> message = EightyUtils.get80(path).allowAccess(path);
        if (message.isPresent()) {
            throw new FileSystemException(message.get());
        }
    }

    private EightyFS checkProviderAndGet80(Path path) {
        if (path.getFileSystem().provider() != this) {
            throw new ProviderMismatchException("expected path for " + this.getScheme() + " got " + path.getFileSystem().provider().getScheme());
        }
        if (!path.getFileSystem().isOpen()) {
            throw new ClosedFileSystemException();
        }
        return ((EightyFileSystem)path.getFileSystem()).get80();
    }

    private void checkURI(URI uri) {
        if (!uri.getScheme().equals(this.getScheme())) {
            throw new IllegalArgumentException("scheme does not fit filesystem, '" + this.getScheme() + "' expected got " + uri.getScheme());
        }
    }

    private String deUri(FileSystem fs, String path) {
        return path.replace("/", fs.getSeparator());
    }

    public void removeAllFileSystemsBut(EightyFileSystem ro) {
        String key = null;
        for (Map.Entry pair : this.fileSystems.entrySet()) {
            if (!((EightyFileSystem)pair.getValue()).equals(ro)) continue;
            key = (String)pair.getKey();
        }
        this.fileSystems.clear();
        if (key != null) {
            this.fileSystems.put(key, ro);
        }
    }
}

