/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.eighty;

import de.pfabulist.lindwurm.eighty.EightyFileSystem;
import de.pfabulist.lindwurm.eighty.EightyUtils;
import de.pfabulist.lindwurm.eighty.path.EightyPath;
import de.pfabulist.lindwurm.eighty.path.EightyPathConstraints;
import de.pfabulist.lindwurm.eighty.path.WindowsPathConstraints;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.Optional;

public class EightyHost {
    public static Optional<String> allowAccess(Path path) {
        if (path instanceof EightyPath) {
            return EightyUtils.get80(path).allowAccess((EightyPath)path);
        }
        return EightyUtils.checkFilenameLength(path, 255);
    }

    public static boolean isWindows(FileSystem fs) {
        try {
            return fs.getPath("C:\\", new String[0]).isAbsolute();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static EightyPathConstraints getPathConstraints(Path path) {
        if (path.getFileSystem() instanceof EightyFileSystem) {
            return EightyUtils.get80(path);
        }
        if (EightyHost.isWindows(path.getFileSystem())) {
            return new WindowsPathConstraints();
        }
        return new EightyPathConstraints(){};
    }
}

