/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.eighty;

import de.pfabulist.kleinod.emergent.Todo;
import de.pfabulist.lindwurm.eighty.EightyFS;
import de.pfabulist.lindwurm.eighty.EightyProvider;
import de.pfabulist.lindwurm.eighty.attributes.AttributesProvider;
import de.pfabulist.lindwurm.eighty.close.CloseWithMe;
import de.pfabulist.lindwurm.eighty.close.InformativeClosable;
import de.pfabulist.lindwurm.eighty.path.EightRegexMatcher;
import de.pfabulist.lindwurm.eighty.path.EightyPath;
import de.pfabulist.lindwurm.eighty.path.GlobToRegex;
import de.pfabulist.lindwurm.eighty.watch.EightyWatchService;
import de.pfabulist.lindwurm.eighty.watch.EightyWatcher;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchEvent;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class EightyFileSystem
extends FileSystem
implements EightyWatcher {
    private static final Logger LOG = Logger.getLogger(EightyFileSystem.class.getName());
    private final EightyFS eightyFS;
    private final EightyProvider provider;
    private final CloseWithMe closeWithMe = new CloseWithMe();
    private final String id;
    private boolean open = true;
    private List<EightyWatchService> watchServices = new ArrayList<EightyWatchService>();
    private final AttributesProvider attributeProvider;
    private static final String REGEX = "regex:";
    private static final String GLOB = "glob:";

    public EightyFileSystem(EightyFS eightyFileSystem, String id, EightyProvider provider, AttributesProvider attributeProvider) {
        this.eightyFS = eightyFileSystem;
        this.provider = provider;
        this.id = id;
        this.attributeProvider = attributeProvider;
    }

    @Override
    public EightyProvider provider() {
        return this.provider;
    }

    @Override
    public void close() throws IOException {
        if (!this.open) {
            return;
        }
        if (!this.eightyFS.isClosable()) {
            throw new UnsupportedOperationException("FileSystem " + this + " can not be closed");
        }
        this.open = false;
        this.closeWithMe.close();
        LOG.info("closed " + this);
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public boolean isReadOnly() {
        return this.eightyFS.isReadOnly();
    }

    @Override
    public String getSeparator() {
        return this.eightyFS.getSeparators().substring(0, 1);
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        List<String> roots = this.eightyFS.getRoots();
        if (roots.isEmpty()) {
            EightyPath root = new EightyPath(this, this.getSeparator(), new String[0]);
            return Collections.singletonList(root);
        }
        ArrayList<Path> ret = new ArrayList<Path>();
        for (String root : roots) {
            ret.add(new EightyPath(this, root + this.getSeparator(), new String[0]));
        }
        return ret;
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return this.eightyFS.getFileStores();
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return this.attributeProvider.supportedFileAttributeViewNames();
    }

    @Override
    public Path getPath(String first, String ... more) {
        return new EightyPath(this, first, more);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        if (syntaxAndPattern.toLowerCase().startsWith(REGEX)) {
            return new EightRegexMatcher(syntaxAndPattern.substring(REGEX.length()));
        }
        if (syntaxAndPattern.toLowerCase().startsWith(GLOB)) {
            new GlobToRegex();
            return new EightRegexMatcher(GlobToRegex.toRegexPattern(syntaxAndPattern.substring(GLOB.length())));
        }
        Todo.todo();
        return null;
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        Todo.todo();
        return null;
    }

    @Override
    public WatchService newWatchService() throws IOException {
        if (!this.eightyFS.watchable()) {
            throw new UnsupportedOperationException();
        }
        EightyWatchService ws = new EightyWatchService(this.eightyFS);
        this.watchServices.add(ws);
        return this.addClosable(ws);
    }

    public EightyFS get80() {
        return this.eightyFS;
    }

    public <T extends InformativeClosable> T addClosable(T cl) {
        this.closeWithMe.add(cl);
        return cl;
    }

    @Override
    public void signal(EightyPath path, WatchEvent.Kind<Path> eventKind) {
        for (EightyWatchService ws : this.watchServices) {
            ws.signal(path, eventKind);
        }
    }

    public void reopen() {
        if (this.open) {
            return;
        }
        if (!this.eightyFS.isReopenable()) {
            throw new IllegalArgumentException("eightfs is not reopenable");
        }
        this.open = true;
        this.eightyFS.reopen();
        LOG.info("reopened " + this);
    }

    public String toString() {
        return "EightFileSystem with " + this.eightyFS;
    }

    public String getId() {
        return this.id;
    }

    public AttributesProvider getAttributeProvider() {
        return this.attributeProvider;
    }
}

