/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.eighty;

import de.pfabulist.kleinod.errors.Unchecked;
import de.pfabulist.kleinod.paths.Filess;
import de.pfabulist.kleinod.paths.Pathss;
import de.pfabulist.lindwurm.eighty.EightySymLink;
import de.pfabulist.lindwurm.eighty.close.CloseableSeekableByteChannel;
import de.pfabulist.lindwurm.eighty.path.EightyPath;
import de.pfabulist.lindwurm.eighty.path.EightyPathConstraints;
import de.pfabulist.lindwurm.eighty.watch.EightyWatcher;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public interface EightyFS
extends EightyPathConstraints {
    public CloseableSeekableByteChannel newByteChannel(EightyPath var1, Set<? extends OpenOption> var2, FileAttribute<?> ... var3);

    public void createDirectory(EightyPath var1, FileAttribute<?> ... var2);

    public void checkAccess(EightyPath var1, AccessMode ... var2);

    public Stream<Path> newDirectoryStream(EightyPath var1);

    default public void copy(EightyPath source, EightyPath target, CopyOption ... options) {
        try (InputStream in = Files.newInputStream(source, new OpenOption[0]);){
            Files.copy(in, (Path)target, new CopyOption[0]);
        }
        catch (IOException e) {
            throw Unchecked.runtime((Exception)e);
        }
    }

    default public void move(EightyPath source, EightyPath target, CopyOption ... options) {
        FileTime lastModi = Filess.getLastModifiedTime((Path)source, (LinkOption[])new LinkOption[0]);
        Pathss.copyRecursive((Path)source, (Path)target, (CopyOption[])options);
        Pathss.deleteRecursive((Path)source);
        Filess.setLastModifiedTime((Path)target, (FileTime)lastModi);
    }

    public void delete(EightyPath var1);

    default public FileStore getFileStore(EightyPath path) {
        throw new UnsupportedOperationException();
    }

    default public Iterable<FileStore> getFileStores() {
        throw new UnsupportedOperationException();
    }

    public <V extends FileAttributeView> V getFileAttributeView(EightyPath var1, Class<V> var2);

    default public boolean isReadOnly() {
        return false;
    }

    default public boolean isHidden(EightyPath paths) {
        return false;
    }

    default public boolean isClosable() {
        return false;
    }

    default public boolean watchable() {
        return false;
    }

    default public boolean isReopenable() {
        return false;
    }

    default public void reopen() {
    }

    default public void setWatcher(EightyWatcher eightyFileSystem) {
    }

    default public void createHardLink(EightyPath normLink, EightyPath normExisting) {
        throw new UnsupportedOperationException("hard links not supported");
    }

    default public void createSymLink(EightyPath link, EightyPath existing, FileAttribute<?>[] attrs) {
        throw new UnsupportedOperationException();
    }

    default public Optional<EightySymLink> getSymlink(EightyPath path) {
        return Optional.empty();
    }
}

