/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.eighty;

import de.pfabulist.kleinod.collection.Iterators;
import de.pfabulist.kleinod.errors.Unchecked;
import de.pfabulist.lindwurm.eighty.close.CloseableDirectoryStream;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.stream.Stream;

public class EightyDirectoryStream
implements CloseableDirectoryStream<Path> {
    private final Stream<Path> stream;
    private final DirectoryStream.Filter<? super Path> filter;
    private final Path dir;
    private boolean calledBefore = false;
    private boolean open = true;

    public EightyDirectoryStream(Path dir, Stream<Path> it, DirectoryStream.Filter<? super Path> filter) {
        this.stream = it;
        this.dir = dir;
        this.filter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Path> iterator() {
        EightyDirectoryStream eightyDirectoryStream = this;
        synchronized (eightyDirectoryStream) {
            if (this.calledBefore) {
                throw new IllegalStateException("iterator() can only called once on a DirectoryStream");
            }
            this.calledBefore = true;
        }
        return Iterators.makeImmutable((Iterator)Iterators.closeable(this.stream.map(path -> this.dir.resolve(path.getFileName().toString())).filter(Unchecked.predicate(this.filter::accept)).iterator(), () -> !this.isOpen()));
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        this.open = false;
    }
}

