package de.pfabulist.lindwurm.eighty.path;

import de.pfabulist.lindwurm.eighty.path.URIMapper;

import java.net.URI;
import java.util.Map;

/**
 * ** BEGIN LICENSE BLOCK *****
 * BSD License (2 clause)
 * Copyright (c) 2006 - 2014, Stephan Pfab
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL Stephan Pfab BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * **** END LICENSE BLOCK ****
 */

/*
 * works with uris of the kind: xxx:name/yyy
 * getSchemeSpecificPart extracts: name
 * getPathPart extracts: /yyy
 */
public class NameURIMapper implements URIMapper {
    private final String scheme;

    public NameURIMapper(String scheme) {
        this.scheme = scheme;
    }

    @Override
    public String getScheme() {
        return scheme;
    }

    @Override
    public String getSchemeSpecificPart( URI uri ) {
        String s = uri.getSchemeSpecificPart();

        int pos = s.indexOf( "/" );
        String name = s;
        if ( pos >= 0 ) {
            name = s.substring( 0, pos );
        }

        return name;
    }

    @Override
    public String getPathPart( URI uri ) {
        String s = uri.getSchemeSpecificPart();

        int pos = s.indexOf( "/" );

        if ( pos < 0 ) {
            throw new IllegalArgumentException( "no path part: " + uri  );
            //return "/";
        }

        return s.substring( pos, s.length() );
    }

    @Override
    public String toString(Object id) {
        return (String)id;
    }

    @Override
    public String fromString(String str, Map<String, Object> env) {
        return str;
    }

    @Override
    public URI toURI( String id) {
        return URI.create( scheme + ":" + id );
    }

}
