package de.pfabulist.lindwurm.eighty.path;

import de.pfabulist.kleinod.collection.P;

import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

/**
 * ** BEGIN LICENSE BLOCK *****
 * BSD License (2 clause)
 * Copyright (c) 2006 - 2014, Stephan Pfab
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL Stephan Pfab BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * **** END LICENSE BLOCK ****
 */
public class GetPathConverter {

    private final EightyPathConstraints ec;
    private final Optional<String> rootComponent;
    private boolean absolute;
    private List<String> elems = new ArrayList<>();

    public GetPathConverter( EightyPathConstraints ec, String first, String ... more ) {
        this.ec = ec;

        P<Optional<String>,String> p = ec.parseRootComponent(first);
        rootComponent = p.i0;
        first = p.i1;

        absolute = !first.isEmpty() && ec.getSeparators().contains( first.substring(0,1));

        add( elems, first );

        for ( String elem : more ) {
            add(  elems, elem );
        }
    }


    private void add( List<String> elems, String one ) {
        for ( String sub : one.split( deregex(ec.getSeparators()) )) {

            ec.findIllegalChars( sub ).
                    ifPresent( ch -> {
                        throw new InvalidPathException( sub, "contains illegal char <" + ch  + ">");});

            if ( !sub.isEmpty()) {
                elems.add( sub ); //trans.apply( sub ));
            }
        }
    }

    public static String deregex( String sep ) {

        String ret = "";

        for ( int i = 0; i < sep.length(); i++ ) {
            if ( sep.charAt(i) == '\\' ) {
                ret += "\\\\|";
            } else {
                ret += sep.charAt(i) + "|";
            }
        }


        return ret.substring(0, ret.length() - 1);
    }

    public boolean isAbsolute() {
        return absolute;
    }

    public String getFirst() {
        if ( elems.isEmpty() ) {
            return "";
        }
        return elems.get( 0 );
    }

    public String[] getMore() {
        if ( elems.isEmpty() ) {
            return new String[]{};
        }
        return elems.subList( 1, elems.size() ).toArray( new String[]{} );
    }

    public List<String> getAll() {
        if ( elems.isEmpty() && !absolute) {
            return Collections.singletonList("");
        }
        return elems;
    }

    public Optional<String> getRootComponent() {
        return rootComponent;
    }
}
