package de.pfabulist.lindwurm.eighty;

import de.pfabulist.lindwurm.eighty.path.EightyPath;
import de.pfabulist.lindwurm.eighty.path.EightyPathConstraints;
import de.pfabulist.lindwurm.eighty.path.WindowsPathConstraints;

import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.Optional;

/**
 * ** BEGIN LICENSE BLOCK *****
 * BSD License (2 clause)
 * Copyright (c) 2006 - 2014, Stephan Pfab
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL Stephan Pfab BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * **** END LICENSE BLOCK ****
 */
public class EightyHost {


    public static Optional<String> allowAccess( Path path ) {

        if ( path instanceof EightyPath) {
            return EightyUtils.get80(path).allowAccess((EightyPath) path);
        }

        return EightyUtils.checkFilenameLength( path, 255 );
    }


    public static boolean isWindows( FileSystem fs ) {
        try {
            return fs.getPath( "C:\\").isAbsolute();
        } catch (Exception e) {
            return false;
        }
    }

    public static EightyPathConstraints getPathConstraints( Path path ) {

        if ( path.getFileSystem() instanceof EightyFileSystem ) {
            return EightyUtils.get80(path);
        }

        if ( isWindows(path.getFileSystem())) {
            return new WindowsPathConstraints();
        }

        return new EightyPathConstraints() {};
    }
}
