package de.pfabulist.lindwurm.eighty;

import de.pfabulist.lindwurm.eighty.close.CloseableDirectoryStream;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.stream.Stream;

import static de.pfabulist.kleinod.collection.Iterators.closeable;
import static de.pfabulist.kleinod.collection.Iterators.makeImmutable;
import static de.pfabulist.kleinod.errors.Unchecked.predicate;

/**
 * ** BEGIN LICENSE BLOCK *****
 * BSD License (2 clause)
 * Copyright (c) 2006 - 2014, Stephan Pfab
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL Stephan Pfab BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * **** END LICENSE BLOCK ****
 */
public class EightyDirectoryStream implements CloseableDirectoryStream<Path> {

    private final Stream<Path> stream;
    private final Filter<? super Path> filter;
    private final Path dir;
    private boolean calledBefore = false;
    private boolean open = true;

    public EightyDirectoryStream( Path dir, Stream<Path> it, DirectoryStream.Filter<? super Path> filter ) {
        this.stream = it;
        this.dir = dir;
        this.filter = filter;
    }

    public Iterator<Path> iterator() {
        synchronized ( this ) {
            if (calledBefore) {
                throw new IllegalStateException("iterator() can only called once on a DirectoryStream");
            }
            calledBefore = true;
        }

        return makeImmutable(
                    closeable( stream.map(path -> //dir.isAbsolute() ? path :
                                                                     dir.resolve(path.getFileName().toString())).
                                      filter(predicate(filter::accept)).iterator(),
                               () -> !isOpen()));

    }

    @Override
    public boolean isOpen() {
        return open;
    }

    @Override
    public void close() throws IOException {
        open = false;
    }

}
