package de.pfabulist.lindwurm.eighty;

import java.nio.file.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * ** BEGIN LICENSE BLOCK *****
 * BSD License (2 clause)
 * Copyright (c) 2006 - 2014, Stephan Pfab
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL Stephan Pfab BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * **** END LICENSE BLOCK ****
 */
public class EightyWatchKey implements WatchKey {
    private final EightyPath watchable;
    private final List<WatchEvent.Kind<?>> watching;
    private List<WatchEvent<?>> happened = new ArrayList<>();
    private boolean ready = true;
    private boolean valid = true;

    public EightyWatchKey(EightyPath path, WatchEvent.Kind<?>... events) {
        watchable = path;
        this.watching = Arrays.asList( events );
    }

    @Override
    public boolean isValid() {
        synchronized (this) {
            if (!Files.exists(watchable)) {
                valid = false;
            }
            return valid;
        }
    }

    @Override
    public List<WatchEvent<?>> pollEvents() {
        List<WatchEvent<?>> ret = new ArrayList<>();
        synchronized ( happened ) {
            ret.addAll( happened );
            happened.clear();
        }
        return ret;
    }

    @Override
    public boolean reset() {
        if ( happened.isEmpty() ) {
            ready = true;
        }

        return valid;
    }

    @Override
    public void cancel() {
        // remove registration
        valid = false;
    }

    @Override
    public Watchable watchable() {
        return watchable;
    }

    public boolean isWatchingFor(EightyPath path, WatchEvent.Kind<Path> event) {
        return valid && watchable.equals(path) && watching.contains(event);
    }

    public void signal(WatchEvent.Kind<Path> event, Path path ) {
        happened.add( new EightyWatchEvent( watchable.relativize(path),event));
        ready = false;
    }

    public boolean isReady() {
        return ready;
    }
}
