//package de.pfabulist.lindwurm.eighty;
//
//import de.pfabulist.kleinod.collection.Sets;
//
//import java.io.IOException;
//import java.nio.file.attribute.BasicFileAttributeView;
//import java.nio.file.attribute.BasicFileAttributes;
//import java.nio.file.attribute.FileTime;
//import java.util.Set;
//
///**
// * ** BEGIN LICENSE BLOCK *****
// * BSD License (2 clause)
// * Copyright (c) 2006 - 2014, Stephan Pfab
// * All rights reserved.
// *
// * Redistribution and use in source and binary forms, with or without
// * modification, are permitted provided that the following conditions are met:
// * * Redistributions of source code must retain the above copyright
// * notice, this list of conditions and the following disclaimer.
// * * Redistributions in binary form must reproduce the above copyright
// * notice, this list of conditions and the following disclaimer in the
// * documentation and/or other materials provided with the distribution.
// *
// * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// * DISCLAIMED. IN NO EVENT SHALL Stephan Pfab BE LIABLE FOR ANY
// * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// * **** END LICENSE BLOCK ****
// */
//public class BasicAttributes extends AttributeInfo {
//    public static final java.lang.String SIZE_NAME = "size";
//    public static final java.lang.String CREATION_TIME_NAME = "creationTime";
//    public static final java.lang.String LAST_ACCESS_TIME_NAME = "lastAccessTime";
//    public static final java.lang.String LAST_MODIFIED_TIME_NAME = "lastModifiedTime";
//    public static final java.lang.String FILE_KEY_NAME = "fileKey";
//    public static final java.lang.String IS_DIRECTORY_NAME = "isDirectory";
//    public static final java.lang.String IS_REGULAR_FILE_NAME = "isRegularFile";
//    public static final java.lang.String IS_SYMBOLIC_LINK_NAME = "isSymbolicLink";
//    public static final java.lang.String IS_OTHER_NAME = "isOther";
//
//    public BasicAttributes() {
//        super( "basic",
//                BasicFileAttributeView.class,
//                BasicFileAttributes.class,
//                new GetSetBasic());
//    }
//
//    public static class GetSetBasic implements AttributeInfo.GetSetAttribute {
//
//        @Override
//        public Set<String> getAttributeNames() {
//            return Sets.asSet( LAST_MODIFIED_TIME_NAME, SIZE_NAME, CREATION_TIME_NAME,
//                    LAST_ACCESS_TIME_NAME, FILE_KEY_NAME, IS_DIRECTORY_NAME, IS_REGULAR_FILE_NAME, IS_SYMBOLIC_LINK_NAME, IS_OTHER_NAME );
//        }
//
//        @Override
//        public Object get( BasicFileAttributeView view, String attribute ) throws IOException {
//            switch( attribute ) {
//                case LAST_MODIFIED_TIME_NAME:
//                    return view.readAttributes().lastModifiedTime();
//                case SIZE_NAME:
//                    return view.readAttributes().size();
//                case CREATION_TIME_NAME:
//                    return view.readAttributes().creationTime();
//                case LAST_ACCESS_TIME_NAME:
//                    return view.readAttributes().lastAccessTime();
//                case FILE_KEY_NAME:
//                    return view.readAttributes().fileKey();
//                case IS_DIRECTORY_NAME:
//                    return view.readAttributes().isDirectory();
//                case IS_REGULAR_FILE_NAME:
//                    return view.readAttributes().isRegularFile();
//                case IS_OTHER_NAME:
//                    return view.readAttributes().isOther();
//                case IS_SYMBOLIC_LINK_NAME:
//                    return view.readAttributes().isSymbolicLink();
//            }
//
//            throw new IllegalArgumentException( attribute + " not a supported Attribute of " + view.getClass() );
//        }
//
//        @Override
//        public void set( BasicFileAttributeView view, String attribute, Object value ) throws IOException {
//            switch( attribute ) {
//                case LAST_MODIFIED_TIME_NAME:
//                    view.setTimes( (FileTime) value, null, null );
//                    break;
//                case CREATION_TIME_NAME:
//                    view.setTimes( null, null, (FileTime) value );
//                    break;
//                case LAST_ACCESS_TIME_NAME:
//                    view.setTimes( null, (FileTime) value, null );
//                    break;
//                default:
//                    throw new IllegalArgumentException( "can't set " + attribute );
//            }
//
//        }
//    }
//
//    public static Object get( BasicFileAttributes read, String attribute ) throws IOException {
//        switch( attribute ) {
//            case LAST_MODIFIED_TIME_NAME:
//                return read.lastModifiedTime();
//            case SIZE_NAME:
//                return read.size();
//            case CREATION_TIME_NAME:
//                return read.creationTime();
//            case LAST_ACCESS_TIME_NAME:
//                return read.lastAccessTime();
//            case FILE_KEY_NAME:
//                return read.fileKey();
//            case IS_DIRECTORY_NAME:
//                return read.isDirectory();
//            case IS_REGULAR_FILE_NAME:
//                return read.isRegularFile();
//            case IS_OTHER_NAME:
//                return read.isOther();
//            case IS_SYMBOLIC_LINK_NAME:
//                return read.isSymbolicLink();
//        }
//
//        throw new IllegalArgumentException( attribute + " not a supported Attribute of " + read.getClass() );
//    }
//
//    public static void set( BasicFileAttributeView view, String attribute, Object value ) throws IOException {
//        switch( attribute ) {
//            case LAST_MODIFIED_TIME_NAME:
//                view.setTimes( (FileTime) value, null, null );
//                break;
//            case CREATION_TIME_NAME:
//                view.setTimes( null, null, (FileTime) value );
//                break;
//            case LAST_ACCESS_TIME_NAME:
//                view.setTimes( null, (FileTime) value, null );
//                break;
//            default:
//                throw new IllegalArgumentException( "can't set " + attribute );
//        }
//
//    }
//}
