package de.pfabulist.lindwurm.eighty;

import de.pfabulist.kleinod.collection.Sets;

import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * ** BEGIN LICENSE BLOCK *****
 * BSD License (2 clause)
 * Copyright (c) 2006 - 2014, Stephan Pfab
 * All rights reserved.
 * <p>
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * <p>
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL Stephan Pfab BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * **** END LICENSE BLOCK ****
 */
public class AttributesBuilder {
    public static final java.lang.String SIZE_NAME = "size";
    public static final java.lang.String CREATION_TIME_NAME = "creationTime";
    public static final java.lang.String LAST_ACCESS_TIME_NAME = "lastAccessTime";
    public static final java.lang.String LAST_MODIFIED_TIME_NAME = "lastModifiedTime";
    public static final java.lang.String FILE_KEY_NAME = "fileKey";
    public static final java.lang.String IS_DIRECTORY_NAME = "isDirectory";
    public static final java.lang.String IS_REGULAR_FILE_NAME = "isRegularFile";
    public static final java.lang.String IS_SYMBOLIC_LINK_NAME = "isSymbolicLink";
    public static final java.lang.String IS_OTHER_NAME = "isOther";

    private List<AttributeConnection> connections = new ArrayList<>();

    public AttributesProvider build() {
        return new AttributesProvider(connections);
    }

    public AttributesBuilder add( AttributeConnection connection ) {
        connections.add( connection );
        return this;
    }

    AttributesBuilder() {}

    public static AttributesBuilder attributes() {
        AttributesBuilder ab = new AttributesBuilder();

        ab.add(ACBuilder.building("basic", BasicFileAttributeView.class, BasicFileAttributes.class).
                addAttribute(LAST_MODIFIED_TIME_NAME, BasicFileAttributes::lastModifiedTime,
                        (view, val) -> view.setTimes((FileTime) val, null, null)).
                addAttribute(LAST_ACCESS_TIME_NAME, BasicFileAttributes::lastAccessTime,
                        (view, val) -> view.setTimes( null, (FileTime) val, null)).
                addAttribute(SIZE_NAME, BasicFileAttributes::size ).
                addAttribute(CREATION_TIME_NAME, BasicFileAttributes::creationTime,
                        (view, val) -> view.setTimes( null, null, (FileTime) val )).
                addAttribute(FILE_KEY_NAME, BasicFileAttributes::fileKey).
                addAttribute(IS_DIRECTORY_NAME, BasicFileAttributes::isDirectory).
                addAttribute(IS_REGULAR_FILE_NAME, BasicFileAttributes::isRegularFile).
                addAttribute(IS_OTHER_NAME, BasicFileAttributes::isOther).
                addAttribute(IS_SYMBOLIC_LINK_NAME, BasicFileAttributes::isSymbolicLink).
                build());

        return ab;
    }
}
