package de.pfabulist.lindwurm.eighty;

import de.pfabulist.kleinod.errors.BiConsumerE;
import de.pfabulist.kleinod.text.Strings;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;

import static de.pfabulist.kleinod.errors.Unchecked.runtime;

/**
 * ** BEGIN LICENSE BLOCK *****
 * BSD License (2 clause)
 * Copyright (c) 2006 - 2014, Stephan Pfab
 * All rights reserved.
 * <p>
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * <p>
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL Stephan Pfab BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * **** END LICENSE BLOCK ****
 */
public class AttributeConnection< V extends BasicFileAttributeView, R extends BasicFileAttributes> {

    private final String name;
    private final Class<V> viewType;
    private final Class<R> readType;
    Map<String, Function<R,Object>> read = new HashMap<>();
    Map<String, BiConsumerE<V,Object>> view = new HashMap<>();

    public AttributeConnection(String name, Class<V> bfav, Class<R> bfas) {
        this.name = name;
        this.viewType = bfav;
        this.readType = bfas;
    }

    public String      getName() {
        return name;
    }

    public Set<String> getAttributeNames() {
        return read.keySet();
    }

    public Class<V>    getViewType() {
        return viewType;
    }

    public Class<R>    getReadType() {
        return readType;
    }

    public Object get( R bfas, String attiName ) {
        if ( !read.containsKey( attiName ) ) {
            throw new IllegalArgumentException( "no such atti " + attiName );
        }

        return read.get( attiName ).apply( bfas );
    }

    public void set( V bfav, String attiName, Object value ) {
        if ( !view.containsKey( attiName ) ) {
            throw new IllegalArgumentException( "no such atti " + attiName );
        }

        try {
            view.get( attiName ).accept( bfav, value );
        } catch (Exception e) {
            throw runtime(e);
        }

    }


//    default Object get( R read, String attiName ) {
//
//        try {
//            Method method = read.getClass().getMethod(attiName, new Class[]{});
//            return method.invoke( read );
//        } catch (NoSuchMethodException e) {
//            e.printStackTrace();
//        } catch (InvocationTargetException e) {
//            e.printStackTrace();
//        } catch (IllegalAccessException e) {
//            e.printStackTrace();
//        }
//        return null;
//    }
//
//    default void set( V view, String attiName, Object value ) {
//        try {
//            Method method = view.getClass().getMethod( "set" + Strings.toFirstUpper(attiName), value.getClass() );
//            method.invoke( view, value );
//            return;
//        } catch (NoSuchMethodException e) {
//            e.printStackTrace();
//        } catch (InvocationTargetException e) {
//            e.printStackTrace();
//        } catch (IllegalAccessException e) {
//            e.printStackTrace();
//        }
//    }
}
