package de.pfabulist.lindwurm.eighty.attributes;

import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Set;

/**
 * ** BEGIN LICENSE BLOCK *****
 * BSD License (2 clause)
 * Copyright (c) 2006 - 2014, Stephan Pfab
 * All rights reserved.
 * <p>
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * <p>
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL Stephan Pfab BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * **** END LICENSE BLOCK ****
 */
public class GuestFileAttributes implements PosixFileAttributes {
    private final boolean sym;
    private final BasicFileAttributes host;

    public GuestFileAttributes( BasicFileAttributes host, boolean sym ) {
        this.sym = sym;
        this.host = host;
    }

    @Override
    public FileTime lastModifiedTime() {
        return host.lastModifiedTime();
    }

    @Override
    public FileTime lastAccessTime() {
        return host.lastAccessTime();
    }

    @Override
    public FileTime creationTime() {
        return host.creationTime();
    }

    @Override
    public boolean isRegularFile() {
        return host.isRegularFile();
    }

    @Override
    public boolean isDirectory() {
        return host.isDirectory();
    }

    @Override
    public boolean isSymbolicLink() {
        return sym;
    }

    @Override
    public boolean isOther() {
        return host.isOther();
    }

    @Override
    public long size() {
        return host.size();
    }

    @Override
    public Object fileKey() {
        return host.fileKey();
    }

    @Override
    public UserPrincipal owner() {
        return ((PosixFileAttributes)host).owner();
    }

    @Override
    public GroupPrincipal group() {
        return ((PosixFileAttributes)host).group();
    }

    @Override
    public Set<PosixFilePermission> permissions() {
        return ((PosixFileAttributes)host).permissions();
    }
}
