package de.pfabulist.lindwurm.eighty;

import de.pfabulist.unchecked.functiontypes.FunctionE;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

/***** BEGIN LICENSE BLOCK *****
* BSD License (2 clause)
* Copyright (c) 2006 - 2015, Stephan Pfab
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*     * Redistributions of source code must retain the above copyright
*       notice, this list of conditions and the following disclaimer.
*     * Redistributions in binary form must reproduce the above copyright
*       notice, this list of conditions and the following disclaimer in the
*       documentation and/or other materials provided with the distribution.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL Stephan Pfab BE LIABLE FOR ANY
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
* ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
***** END LICENSE BLOCK *****/
public class RuntimeProxy {

    private RuntimeProxy(){}

    public interface JustNull {
        Class getNullClass();
    }

    public static <T> T of( Class<T> clazz, FunctionE<String, Object, Exception > meth ) {
        if ( !clazz.isInterface()) {
            throw new UnsupportedOperationException( "foo" );
        }

        return (T) Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz/*, JustNull.class*/}, new CoercedProxy(clazz, meth ));
    }

    @SuppressWarnings( "PMD.CyclomaticComplexity" )
    public static class CoercedProxy implements InvocationHandler {

        private final Class clazz;
        private final FunctionE<String, Object, Exception> meth;

        private CoercedProxy(Class clazz, FunctionE<String, Object, Exception> meth) {
            this.clazz = clazz;
            this.meth = meth;

        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {

            String methodName = method.getName();

            if (methodName.equals("getNullClass") && (args == null || args.length == 0)) {
                return clazz;
            }

            // it delegates the hashCode and the equals methods to the proxy class
            if (methodName.equals("hashCode") && (args == null || args.length == 0)) {
                return clazz.hashCode();
            }

            if (methodName.equals("equals") && args.length == 1 && args[0] instanceof JustNull) {
                return ((JustNull)args[0]).getNullClass() == clazz;
            }

            if ( methodName.equals("toString")) {
                return "RuntimePorcy of " + clazz;
            }

            return meth.apply( methodName );
        }
    }
}