package de.pfabulist.lindwurm.eighty.path;

import de.pfabulist.lindwurm.eighty.RealPath;

import java.nio.file.LinkOption;
import java.nio.file.Path;

/**
 * ** BEGIN LICENSE BLOCK *****
 * BSD License (2 clause)
 * Copyright (c) 2006 - 2015, Stephan Pfab
 * All rights reserved.
 * <p>
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * <p>
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL Stephan Pfab BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * **** END LICENSE BLOCK ****
 */

public class ProviderPath {

    public static EightyPath toRealPathEx( Path path, LinkOption... options ) {

        if( !( path instanceof EightyPath ) ) {
            throw new IllegalArgumentException( path + " should be EightyPath" );
        }

        if( options.length == 0 ) {
            return toRealPath( path );
        }

        if( path.getParent() == null ) {
            return (EightyPath) path;
        }

        if ( ((EightyPath)path).knownReal() ) {
            return (EightyPath) path;
        }

        EightyPath parent = toRealPath( path.getParent() );
        return (EightyPath) parent.resolve( path.getFileName() );
    }

    public static EightyPath toRealPath( Path path ) {
        if( !( path instanceof EightyPath ) ) {
            throw new IllegalArgumentException( path + " should be EightyPath" );
        }

        if ( ((EightyPath)path).knownReal() ) {
            return (EightyPath) path;
        }

        return (EightyPath) new RealPath( (EightyPath) path ).to();
    }


}
