package de.pfabulist.lindwurm.eighty.attributes;

import java.nio.file.attribute.FileAttributeView;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * ** BEGIN LICENSE BLOCK *****
 * BSD License (2 clause)
 * Copyright (c) 2006 - 2015, Stephan Pfab
 * All rights reserved.
 * <p>
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * <p>
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL Stephan Pfab BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * **** END LICENSE BLOCK ****
 */

public class OneClassAttributes extends RWAttributes {

    Map<String, Function<FileAttributeView, Object>> reads = new HashMap<>();
    Map<String, BiConsumer<FileAttributeView, Object>> writes = new HashMap<>();

    public <V extends FileAttributeView> OneClassAttributes( String name, Class<V> viewT ) {
        super( name, (Class)viewT );
    }

    @Override
    public Object read( FileAttributeView view, String attiName ) {
        Function<FileAttributeView,Object> f = reads.get( attiName );

        if ( f == null ) {
            throw new IllegalArgumentException( "attribute " + attiName + " not in view " + getViewName());
        }

        return f.apply( view );
    }


    @Override
    public Set<String> getAttributeNames() {
        return reads.keySet();
    }

    @Override
    public void set( FileAttributeView view, String name, Object value ) {
        writes.get( name ).accept( view, value );
    }

    @Override
    public boolean isSettable( String attiName ) {
        return writes.containsKey( attiName );
    }

}
