package de.pfabulist.lindwurm.eighty.attributes;

import java.io.IOException;
import java.nio.file.ReadOnlyFileSystemException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Set;

/**
 * ** BEGIN LICENSE BLOCK *****
 * BSD License (2 clause)
 * Copyright (c) 2006 - 2014, Stephan Pfab
 * All rights reserved.
 * <p>
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * <p>
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL Stephan Pfab BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * **** END LICENSE BLOCK ****
 */
public class GuestFileAttributeView implements PosixFileAttributeView, LinkInfoSettable, ReadonlySettable {
    protected final FileAttributeView host;
    protected boolean sym;
    private boolean readonly;

    public GuestFileAttributeView( FileAttributeView host ) {
        this.host = host;
        this.sym = false;
    }

    @Override
    public String name() {
        return host.name();
    }

    @Override
    public UserPrincipal getOwner() throws IOException {
        return ownerHost().getOwner();
    }

    @Override
    public void setOwner( UserPrincipal owner ) throws IOException {
        ownerHost().setOwner( owner );
    }

    @Override
    public GuestFileAttributes readAttributes() throws IOException {
        return new GuestFileAttributes( basicHost().readAttributes(), sym );
    }

    @Override
    public void setPermissions( Set<PosixFilePermission> perms ) throws IOException {
        posixHost().setPermissions( perms );
    }

    private PosixFileAttributeView posixHost() {
        return (PosixFileAttributeView)host;
    }

    @Override
    public void setGroup( GroupPrincipal group ) throws IOException {
        posixHost().setGroup( group );
    }

    @Override
    public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
        if ( readonly ) {
            throw new ReadOnlyFileSystemException();
        }
        basicHost().setTimes( lastModifiedTime, lastAccessTime, createTime );
    }

    @Override
    public void setLink() {
        sym = true;
    }

    @Override
    public void setReadonly() {
        readonly = true;
    }

    public FileOwnerAttributeView ownerHost() {
        return (FileOwnerAttributeView)host;
    }

    private BasicFileAttributeView basicHost() {
        return (BasicFileAttributeView)host;
    }

}
