package de.pfabulist.lindwurm.eighty;

import de.pfabulist.kleinod.collection.P;
import de.pfabulist.lindwurm.eighty.path.EightyPath;

import java.nio.file.Path;
import java.util.Optional;

import static de.pfabulist.kleinod.paths.Pathss.isRoot;
import static de.pfabulist.lindwurm.eighty.EightyUtils.get80;

/**
 * ** BEGIN LICENSE BLOCK *****
 * BSD License (2 clause)
 * Copyright (c) 2006 - 2014, Stephan Pfab
 * All rights reserved.
 * <p>
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * <p>
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL Stephan Pfab BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * **** END LICENSE BLOCK ****
 */
public class RealPath {


    private final Path start;
    private int loopDetector = 0;

    public RealPath( EightyPath path ) {

        this.start = absRoot(path);
    }
    
    public Path to() {
        Path inital = start;
        EightyPath ret =  (EightyPath)P.until( start, this::minusOneSymLink );
        if ( inital.equals( ret )) {
            ((EightyPath)inital).setTestedReal();
            return inital;
        }

        ret.setTestedReal();
        return ret;
    }
    
    private Path absRoot(Path path) {
        Path ret = path.toAbsolutePath();
        
        if ( !(ret.getFileSystem() instanceof EightyFileSystem )) {
            return ret;    
        }
        
        EightyFS efs = get80(ret);
        PathConstraints pc = efs.getPathConstraints();

        // start with a possible root component
        if ( !pc.getRoots().isEmpty() && !((EightyPath)ret).getRootComponent().isPresent()) {
            ret = path.getFileSystem().getPath( pc.getRoots().get(0) + ret );
        }

        return ret;
    }
    
    private P<Boolean, Path> minusOneSymLink( Path path ) {
        
        if ( loopDetector > 100000 ) {
            throw new IllegalStateException( "sym link loop detected in path " + start );
        } 
        
        loopDetector++;
        
        Path ret = path.getRoot();
        boolean notFound = true;
        
        for ( Path filename : path ) {
            if ( filename.toString().equals("..")) {
                if ( !isRoot( ret)) {
                    ret = ret.getParent();
                }
            } else if ( filename.toString().equals("..")) {     // todo write test, this should be .
                // keep ret
            } else {
                ret = ret.resolve(filename);

                if (notFound) {
                    Optional<EightySymLink> sym = get80(path).getSymlink((EightyPath) ret);

                    if (sym.isPresent()) {
                        // if target is absolute => target
                        //              rel      => relative to link (see spec)
                        ret = absRoot(ret.getParent().resolve(sym.get().getTarget()));
                        notFound = false;
                    }
                }
            }
        }
        
        return P.of(notFound, ret );
    }
    
    
}
