package de.pfabulist.lindwurm.eighty;

import de.pfabulist.kleinod.collection.P;
import de.pfabulist.kleinod.collection.Ref;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

/**
 * ** BEGIN LICENSE BLOCK *****
 * BSD License (2 clause)
 * Copyright (c) 2006 - 2015, Stephan Pfab
 * All rights reserved.
 * <p>
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * <p>
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL Stephan Pfab BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * **** END LICENSE BLOCK ****
 */

public interface PathConstraints {

    PathConstraints UnixUnlimited = new PathConstraints() {};

    /**
     * test whether the string is valid path element, i.e. relevant for path construction
     * moslty whether it contains any illegal chars
     * note: length is not relevant here
     * @param str a potential filename
     * @param reason why it is not a filename for the current filesystem
     * @return whether it is a valid filename for that filesystem
     */
    default boolean isFilenameValid( String str, Ref<String> reason ) {
        return true;
    }

    default boolean isPathAccessible( Path path, Ref<String> reason ) {
        return true;
    }

    default String getMainSeparator()  {
        return "/";
    }

    default List<String> getAllSeparators() {
        return Collections.singletonList( "/" );
    }

    default P<Optional<String>, String> parseRootComponent( String str ) {
        return P.of( Optional.empty(),
                     str );
    }

    default List<String> getRoots() {
        return Collections.emptyList();
    }

    default boolean nameEquals( String a, String b ) {
        return a.equals( b );
    }

    default int nameHash( String a ) {
        return a.hashCode();
    }

}
