package de.pfabulist.lindwurm.eighty;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

/**
 * ** BEGIN LICENSE BLOCK *****
 * BSD License (2 clause)
 * Copyright (c) 2006 - 2014, Stephan Pfab
 * All rights reserved.
 * <p>
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * <p>
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL Stephan Pfab BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * **** END LICENSE BLOCK ****
 */
public class GuestChannel extends FileChannel {

    final FileChannel host;
    private final Runnable onClose;

    public GuestChannel( FileChannel host, Runnable onClose ) {
        this.host = host;
        this.onClose = onClose;
    }

    @Override
    public int read( ByteBuffer dst ) throws IOException {
        return host.read( dst );
    }

    @Override
    public long read( ByteBuffer[] dsts, int offset, int length ) throws IOException {
        return host.read( dsts, offset, length );
    }

    @Override
    public int write( ByteBuffer src ) throws IOException {
        return host.write( src );
    }

    @Override
    public long write( ByteBuffer[] srcs, int offset, int length ) throws IOException {
        return host.write( srcs, offset, length );
    }

    @Override
    public long position() throws IOException {
        return host.position();
    }

    @Override
    public FileChannel position( long newPosition ) throws IOException {
        return host.position( newPosition );
    }

    @Override
    public long size() throws IOException {
//        if( !host.isOpen() ) {
//            throw new ClosedChannelException();
//        }
        return host.size();
    }

    @Override
    public FileChannel truncate( long size ) throws IOException {
//        if( !host.isOpen() ) {
//            throw new ClosedChannelException();
//        }
        return host.truncate( size );
    }

    @Override
    public void force( boolean metaData ) throws IOException {
        host.force( metaData );
    }

    @Override
    public long transferTo( long position, long count, WritableByteChannel target ) throws IOException {
        return host.transferTo( position, count, target );
    }

    @Override
    public long transferFrom( ReadableByteChannel src, long position, long count ) throws IOException {
        return host.transferFrom( src, position, count );
    }

    @Override
    public int read( ByteBuffer dst, long position ) throws IOException {
        return host.read( dst, position );
    }

    @Override
    public int write( ByteBuffer src, long position ) throws IOException {
        return host.write( src, position );
    }

    @Override
    public MappedByteBuffer map( MapMode mode, long position, long size ) throws IOException {
        return host.map( mode, position, size );
    }

    @Override
    public FileLock lock( long position, long size, boolean shared ) throws IOException {
        return host.lock( position, size, shared );
    }

    @Override
    public FileLock tryLock( long position, long size, boolean shared ) throws IOException {
        return host.tryLock( position, size, shared );
    }

    @Override
    protected void implCloseChannel() throws IOException {
        host.close();
        onClose.run();
    }
}
