package de.pfabulist.jlot;

import de.pfabulist.roast.Roast;
import org.junit.jupiter.api.TestInfo;

import java.util.Set;

import static de.pfabulist.roast.NonnullCheck._nn;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class TestInfoo implements Roast<TestInfo> {
    private final TestInfo inner;

    public TestInfoo( TestInfo inner ) {
        this.inner = inner;
    }

    @Override
    public TestInfo unwrap() {
        return inner;
    }

    public static TestInfoo of( TestInfo testInfo ) {
        return new TestInfoo( testInfo );
    }

    public String getDisplayName() {
        return _nn( inner.getDisplayName() );
    }

    public Set<String> getTags() {
        return _nn( inner.getTags() );
    }
}
